package ibase.e12ria.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.google.code.gwt.storage.client.Storage;
import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.dom.client.Touch;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.TouchMoveEvent;
import com.google.gwt.event.dom.client.TouchMoveHandler;
import com.google.gwt.event.dom.client.TouchStartEvent;
import com.google.gwt.event.dom.client.TouchStartHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

import ibase.e12ria.e12widgets.client.E12AlertBox;
import ibase.e12ria.e12widgets.client.E12ApplicationsPanel;
import ibase.e12ria.e12widgets.client.E12ExplorerPanel;
import ibase.e12ria.e12widgets.client.E12OptionsPanel;
import ibase.e12ria.e12widgets.client.E12PopupPanel;
import ibase.e12ria.e12widgets.client.E12Search;
import ibase.e12ria.e12widgets.client.E12SocialModel;
import ibase.e12ria.e12widgets.client.E12SocialPanel;
import ibase.e12ria.e12widgets.client.FavouritePanel;
import ibase.e12ria.e12widgets.client.PanelLabel;
import ibase.e12ria.e12widgets.client.TouchWidget;
import ibase.e12ria.e12widgets.client.WrapSiteInfo;
import ibase.e12ria.e12widgets.client.handlers.CallbackHandler;
import ibase.e12ria.e12widgets.shared.E12CommonUtils.DeviceOS;
import ibase.e12ria.e12widgets.shared.E12Storage;
import ibase.e12ria.social.client.plugins.misc.CachedImage;

//public class E12SlideMenuPanel extends WallToWallPanel
public class E12SlideMenuPanel
{
	//public PopupPanel slidePopupPnl = null;
	public CustomPopUp slidePopupPnl = null;
	//Added by Pooja S on 11-Sept-2019 [UI related changes in the slide menu panel] Start
	private final FlowPanel exploreDetailPathPanel = new FlowPanel();
	private final FlowPanel menuContentPanel = new FlowPanel();
	private final FlowPanel exploreOptions = new FlowPanel();
	final Label showAllLbl = new Label( E12Constants.constants.setShowAllLbl() );
	final Label showAllLblIcon = new Label();
	final Label favouriteLbl = new Label( E12Constants.constants.setFavouriteLbl() );
	final Label favouriteLblIcon = new Label();
	final Label assistantLbl = new Label( E12Constants.constants.setAssistant() );
	final Label assistantLblIcon = new Label();
	//Added by Pooja S on 11-Sept-2019 [UI related changes in the slide menu panel] End
	//private static E12SlideMenuPanel e12SlideMenuPanel;
	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
	protected PanelLabel panelLabel = null;
	protected MELogin meLogin = null;
	private String conIdToDelete = "";
	private boolean isClick = false;
	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
	private String redirectPath = "";
	private E12SlideMenuPanel()
	{

	}

	//  public static E12SlideMenuPanel getInstance()
	//  {
	//      if(e12SlideMenuPanel == null){
	//      	e12SlideMenuPanel = new E12SlideMenuPanel();
	//      }
	//      return e12SlideMenuPanel;
	//  }

	public static E12SlideMenuPanel getInstance( String userId )
	{
		//changed by Nikita S on 17/05/17 [resolve slide menu panel issue] start
		String key = "";
		//Added by Sandeep S. on 21-07-17 [To implement delete cache in Mobile] start
		E12SlideMenuPanel e12SlideMenuPanel = null;
		if( "deleteCache".equalsIgnoreCase(userId) )
		{
			menuPanelMap.clear();
		}
		else
		{
			if( userId.contains("-"))
			{
				key = userId;
			}
			else
			{
				key = userId+"-"+E12Constants.conApplNm;
			}

			e12SlideMenuPanel = menuPanelMap.get( key );
			if( e12SlideMenuPanel == null )
			{
				e12SlideMenuPanel = new E12SlideMenuPanel();
				menuPanelMap.put(key, e12SlideMenuPanel);
			}
			//Added by Sandeep S. on 21-07-17 [To implement delete cache in Mobile] end
		}
		return e12SlideMenuPanel;
	}
	//changed by Nikita S on 17/05/17 [resolve slide menu panel] end

	//	public E12SlideMenuPanel(String title, WallToWallPanel parent) {
	//		super(title, parent);
	//	}

	private FlowPanel vPanel = new FlowPanel();
	HashMap<String, E12Feed> featuresMap = new HashMap<String, E12Feed>();
	LinkedList<String> optionsList = new LinkedList<String>();
	JavaScriptObject e12SlideMenuHeadRoomObj = null;
	boolean isFavouriteOpen = false;
	boolean isExplorerOpen = false;
	boolean isAssistantOpen = false;
	static HashMap<String, E12SlideMenuPanel> menuPanelMap = new HashMap<String, E12SlideMenuPanel>();

	public void createSlideMenuPanel( LinkedList<String> optionsList, String parentOption, String redirectPath )
	{
		this.redirectPath = redirectPath;
		createSlideMenuPanel( optionsList, parentOption );
	}

	/**
	 * This method is called to build slideMenu panel.
	 * @param optionsList
	 * @param parentOption
	 */
	public void createSlideMenuPanel( LinkedList<String> optionsList, String parentOption )
	{
		this.optionsList = optionsList;

		E12Global.getInstance().optionSelected = parentOption;
		E12CommonUtils.printOnConsole("E12SlideMenuPanel hostedMode ["+E12Global.getInstance().isHostedMode()+"] UserLoginCode ["+E12Constants.userID+"]");
		E12CommonUtils.printOnConsole("In createSlideMenuPanel Redirect Path : "+redirectPath);
		//E12CommonUtils.printOnConsole("In slidePopupPnl : "+slidePopupPnl);
		int clientHeight = Window.getClientHeight();
		int clientWidth = Window.getClientWidth();
		E12CommonUtils.getInstance().closePopUps("Logout_Close");
		E12CommonUtils.getInstance().closePopUps("closeMyPlace");
		if( slidePopupPnl != null && redirectPath.trim().length() > 5 )
		{
			slidePopupPnl = null;
		}
		if( slidePopupPnl == null )
		{
			//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
			isFavouriteOpen = false;
			isExplorerOpen = false;
			//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end

			createOptionsList();
			vPanel.getElement().setId("OuterVertPanel");

			E12CommonUtils.printOnConsole("546 CreateOption clientHeight ["+clientHeight+"] clientWidth ["+clientWidth+"]");
			//Changed by Sandeep S. on 20-MAR-18 [local storage & indexed db related changes] start
			final FlowPanel topHpnl = new FlowPanel();
			topHpnl.getElement().setId("topHpnl");
			topHpnl.setStyleName("topOuterPnl");
			
			//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[Start]
			if(DeviceOS.iOS == E12Global.getInstance().getDeviceOS()){
				if(Window.Navigator.getPlatform().equalsIgnoreCase("iphone")){
					if(Window.getClientHeight() > 800 && Window.getClientWidth() > 370){
						topHpnl.getElement().getStyle().setPaddingTop(20, Unit.PX);						
					}
				}
			}	  
			//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[End]

			//Added by Pankaj R on 21-Dec-2017 to set Current App Name[start]
			String curConnId = "";
			curConnId = E12CommonUtils.checkNull( E12Global.getInstance().getCurConnectionId() );
			curConnId = curConnId.substring(1, curConnId.length() - 2);
			//String currConnectionInfo = E12Storage.getItem(curConnId);
			E12Storage.getItem(curConnId, new Callback<String, String>() {

				@Override
				public void onFailure(String reason) {
					// TODO Auto-generated method stub

				}

				@Override
				public void onSuccess(String result) {

					//Changed by Prasad on 14/09/19 [menn panel related ui changes] START
					FlowPanel topTitlenLogo = getClientDetailPanel( result );
					topHpnl.add(topTitlenLogo);

					//final FlowPanel middleHpnlTop = new FlowPanel();
					exploreDetailPathPanel.getElement().setId( "middleHpnlTop" );
					exploreDetailPathPanel.setStyleName( "middleHpnlTop" );

					//final FlowPanel middleHpnl = new FlowPanel();
					menuContentPanel.getElement().setId( "middleHpnl" );
					menuContentPanel.setStyleName( "middleHpnlOptions" );

					final FlowPanel middleHpnlOuter = new FlowPanel();
					middleHpnlOuter.getElement().setId( "middleHpnlOuter" );

					//final Label favouriteLbl = new Label( E12Constants.constants.setFavouriteLbl() );
					favouriteLbl.getElement().setId( "favouriteMenuId_slidePanel" );
					favouriteLbl.setStyleName( "topBtnCSS" );
					favouriteLbl.addStyleName( "favBtn" );
					favouriteLbl.addStyleName( "btnDeselect" );

					//final Label favouriteLblIcon = new Label("");
					favouriteLblIcon.setStyleName( "vision-ui-heart" );
					favouriteLblIcon.addStyleName( "exploreOptionIcon" );
					favouriteLblIcon.addStyleName( "btnDeselect" );

					//final Label showAllLbl = new Label( E12Constants.constants.setShowAllLbl() );
					showAllLbl.getElement().setId( "showAllMenuId_slidePanel" );
					showAllLbl.setStyleName( "topBtnCSS" );

					//final Label showAllLblIcon = new Label("");
					showAllLblIcon.setStyleName( "vision-ui-list" );
					showAllLblIcon.addStyleName( "exploreOptionIcon" );
					showAllLblIcon.addStyleName( "btnDeselect" );

					//final Label assistantLbl = new Label( E12Constants.constants.setAssistant() );
					assistantLbl.getElement().setId( "assistantMenuId_slidePanel" );
					assistantLbl.addStyleName( "topBtnCSS" );
					assistantLbl.addStyleName( "btnDeselect" );

					//final Label assistantLblIcon = new Label("");
					assistantLblIcon.setStyleName( "vision-ui-assistance" );
					assistantLblIcon.addStyleName( "exploreOptionIcon" );
					assistantLblIcon.addStyleName( "btnDeselect" );

					FlowPanel assistantFlowPanel = new FlowPanel();
					assistantFlowPanel.setStyleName( "exploreOption" );

					assistantFlowPanel.add(assistantLblIcon);
					assistantFlowPanel.add(assistantLbl);

					assistantFlowPanel.addDomHandler(new ClickHandler() {

						@Override
						public void onClick(ClickEvent event) {

							if( ! isAssistantOpen() )
							{
								setAssistantOpen( true );
								setExplorerOpen( false );
								setFavouriteOpen( false );

								menuContentPanel.clear();
								if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS )
								{
									Window.scrollTo(0, 0);
									Element contents =  DOM.getElementById( "MobileContents" );
									if( contents != null )
									{
										E12CommonUtils.printOnConsole("Bhudroid contents 421");
										contents.setScrollTop(0);
									}
								}

								E12PopupPanel assistantPanel = E12Global.getInstance().getAssistantPopupPanel();
								if( assistantPanel != null )
								{
									assistantPanel.show();
									E12CommonUtils.printOnConsole("assistantPanel != null22");
									menuContentPanel.add( assistantPanel );
									E12CommonUtils.printOnConsole("assistantPanel != null33");
								}
								else
								{
									E12CommonUtils.printOnConsole("assistantPanel ===== null");
									//E12Global.getInstance().assistantCount = 0;
									menuContentPanel.add( new E12UserInfo().getAssistantComponent( "", slidePopupPnl, menuContentPanel ) );
								}
							}
						}
					},  ClickEvent.getType());

					FlowPanel favFlowPanel = new FlowPanel();
					favFlowPanel.addStyleName( "exploreOption" );

					favFlowPanel.add( favouriteLblIcon );
					favFlowPanel.add( favouriteLbl );

					favFlowPanel.addDomHandler(new ClickHandler() {

						@Override
						public void onClick(ClickEvent event) {

							if( ! isFavouriteOpen() )
							{
								try
								{
									setFavouriteOpen( true );
									setExplorerOpen( false );
									setAssistantOpen( false );

									menuContentPanel.clear();
									exploreDetailPathPanel.clear();

									exploreDetailPathPanel.removeStyleName("middleHpnlTopClick");
									exploreDetailPathPanel.setStyleName("middleHpnlTop");
									menuContentPanel.removeStyleName("middleHpnlOptionsClick");
									menuContentPanel.setStyleName("middleHpnlOptions");

									E12PopupPanel assistantPanel = E12Global.getInstance().getAssistantPopupPanel();
									if(assistantPanel != null)
									{
										assistantPanel.hide();
										E12Global.getInstance().setAssistantPopupPanel(null);
									}

									FavouritePanel e12FavPanel = null;
									e12FavPanel = (FavouritePanel) E12Global.getInstance().getPanel("M_Favourite");
									if( e12FavPanel == null )
									{
										e12FavPanel = new FavouritePanel( "Favourite", null, menuContentPanel, true );
										e12FavPanel.setFavTabClicked( true );
									}
								}
								catch (Exception e)
								{
									E12CommonUtils.printOnConsole("Exception onFavourite click :"+e.getMessage()+"]");
								}
							}
							else
							{
								E12CommonUtils.printOnConsole("you click Favourite still its open ");
							}
						}
					}, ClickEvent.getType());

					FlowPanel showAllFlowPanel = new FlowPanel();
					showAllFlowPanel.addStyleName( "exploreOption" );

					showAllFlowPanel.add(showAllLblIcon);
					showAllFlowPanel.add(showAllLbl);

					showAllFlowPanel.addDomHandler(new ClickHandler() {

						@Override
						public void onClick(ClickEvent event) {

							if( ! isExplorerOpen() )
							{
								try
								{
									setExplorerOpen( true );
									setAssistantOpen( false );
									setFavouriteOpen( false );

									menuContentPanel.clear();
									exploreDetailPathPanel.clear();

									exploreDetailPathPanel.removeStyleName("middleHpnlTopClick");
									exploreDetailPathPanel.setStyleName("middleHpnlTop");
									menuContentPanel.removeStyleName("middleHpnlOptionsClick");
									menuContentPanel.setStyleName("middleHpnlOptions");

									E12PopupPanel assistantPanel = E12Global.getInstance().getAssistantPopupPanel();
									if( assistantPanel != null )
									{
										assistantPanel.hide();
										E12Global.getInstance().setAssistantPopupPanel(null);
									}

									E12ExplorerPanel e12ExplorerPanel = null;
									//e12ExplorerPanel = ( E12ExplorerPanel ) E12Global.getInstance().getPanel("M_E12Explorer");
									if( e12ExplorerPanel == null )
									{
										e12ExplorerPanel = new E12ExplorerPanel( "Explorer", null, menuContentPanel, exploreDetailPathPanel, true, "" );
									}
								}
								catch (Exception e)
								{
									E12CommonUtils.printOnConsole("Exception onshowAll click :"+e.getMessage()+"]");
								}
							}
						}
					}, ClickEvent.getType());

					TouchWidget favBtnWidget = new TouchWidget( favFlowPanel );
					favBtnWidget.getElement().setId("favBtnWidget_slidePanel");

					TouchWidget showAllBtnWidget = new TouchWidget( showAllFlowPanel );
					showAllBtnWidget.getElement().setId("showAllBtnWidget_slidePanel");

					final TouchWidget assistantLblWigt = new TouchWidget( assistantFlowPanel );
					assistantLblWigt.getElement().setId("assistantWidget_slidePanel");

					//FlowPanel exploreOption = new FlowPanel();
					exploreOptions.getElement().setId( "topButton-"+E12Constants.userID+"_"+E12Constants.conApplNm );
					//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[Start]
					if(DeviceOS.iOS == E12Global.getInstance().getDeviceOS())
					{
					  if(Window.Navigator.getPlatform().equalsIgnoreCase("iphone"))
					  {
						  if(Window.getClientHeight() > 800 && Window.getClientWidth() > 370)
						  {
							  //Changed By Ravindra C on  24-02-20 for iphone button display related changes 
							  //exploreOptions.getElement().getStyle().setPaddingBottom(20, Unit.PX);
							  exploreOptions.getElement().getStyle().setPaddingBottom(10, Unit.PX);	
						  }
					  }
					}
					//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[Start][End]
					exploreOptions.setStyleName( "topBtnPnl" );

					exploreOptions.add( favBtnWidget );
					exploreOptions.add( showAllBtnWidget );
					exploreOptions.add( assistantLblWigt );

					E12CommonUtils.printOnConsole("you click ShowAll featuresMap "+featuresMap);

					middleHpnlOuter.add( menuContentPanel );
					middleHpnlOuter.add( exploreOptions );

					E12CommonUtils.printOnConsole("E12Fav path : [" + E12Global.getInstance().getRedirectPath() + "]");
					if( E12Global.getInstance().getRedirectPath() == null )
					{
						setFavouriteOpen(true);

						FavouritePanel e12FavPanel = null;
						//e12FavPanel = (FavouritePanel) E12Global.getInstance().getPanel("M_Favourite");
						if( e12FavPanel == null )
						{
							e12FavPanel = new FavouritePanel("Favourite", null, menuContentPanel, true );
							e12FavPanel.setFavTabClicked(false);   //Added by Bhupendra M for Ui realted changes in App on 11-10-17
						}
					}
					//Added and commented by Vikas Lagad on 19.10.18 to show favorite menu on slider[START]
					else if ( ( E12Global.getInstance().getRedirectPath() != null )
							&& "DAS.".equalsIgnoreCase( E12Global.getInstance().getRedirectPath() )
							&& E12Constants.IS_FAV_MENU )
					{
						setFavouriteOpen(true);

						FavouritePanel e12FavPanel = null;
						if ( e12FavPanel == null )
						{
							e12FavPanel = new FavouritePanel("Favourite", null, menuContentPanel, true);
							E12CommonUtils.printOnConsole("MiddlePanel Count : [" + menuContentPanel.getWidgetCount() + "]");
							e12FavPanel.setFavTabClicked(false); // Added by Bhupendra M for Ui realted changes in App
						}
					}
					else
					{
						setExplorerOpen(true);

						//Added and commented by Vikas Lagad on 19.10.18 to show favorite menu on slider[END]
						E12ExplorerPanel e12ExplorerPanel = null;
						//e12ExplorerPanel = ( E12ExplorerPanel ) E12Global.getInstance().getPanel("M_E12Explorer");
						if( e12ExplorerPanel == null )
						{
							E12CommonUtils.printOnConsole("E12SlideMenuOption --- exp pnl is null");
							e12ExplorerPanel = new E12ExplorerPanel("Explorer", null, menuContentPanel, exploreDetailPathPanel, true, redirectPath );
							redirectPath = "";
						}
					}
					//e12FavPanel.middleSlideMenuPnl = middleHpnl;
					//e12FavPanel.isSlideMenuPanel = true;

					FlowPanel bottomHpnl = new FlowPanel();
					//bottomHpnl.getElement().setId("bottomHpnl_slideMenu");
					bottomHpnl.getElement().setId( "bottomHpnl-"+E12Constants.userID+"_"+E12Constants.conApplNm );
					bottomHpnl.setStyleName( "bottomHpnlCSS" );
					bottomHpnl.getElement().setAttribute( "align", "center" );
					//bottomHpnl.getElement().setAttribute("style", "background: linear-gradient(to right,var(--primary, #aeaeae) 30%, var(--primary) 100%);");

					//when there is single option
					if( featuresList.size() == 1 )
					{
						for( int i = 0; i < 4; i++ )
						{
							if( i == 2 )
							{
								for(Map.Entry<String, E12Feed> m : featuresMap.entrySet())
								{
									E12Feed feed = m.getValue();
									if( feed.getTitle().equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
									{
										topHpnl.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
									}
									else
									{
										bottomHpnl.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
									}
									i++;
								}
							}
							else
							{
								E12Feed blankFeed = getBlankFeed();
								if( blankFeed.getTitle().equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
								{
									topHpnl.add( getPanel( blankFeed.getTitle(), blankFeed.getComment(), blankFeed.getIcon(), i, true ) );
								}
								else
								{
									bottomHpnl.add( getPanel( blankFeed.getTitle(), blankFeed.getComment(), blankFeed.getIcon(), i, false ) );
								}
							}
						}
					}
					else if( featuresList.size() == 2 )
					{
						//when there are two options
						E12Feed blankFeed = getBlankFeed();
						bottomHpnl.add( getPanel( blankFeed.getTitle(), blankFeed.getComment(), blankFeed.getIcon(), 0, false ) );

						int i = 1;
						for(Map.Entry<String, E12Feed> m : featuresMap.entrySet())
						{
							E12Feed feed = m.getValue();
							if( feed.getTitle().equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
							{
								topTitlenLogo.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
							}
							else
							{
								bottomHpnl.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
							}
							i++;
						}
					}
					else
					{
						int i = 0;
						for(Map.Entry<String, E12Feed> m : featuresMap.entrySet())
						{
							E12Feed feed = m.getValue();
							if( feed.getTitle().equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
							{
								topTitlenLogo.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
							}
							else
							{
								bottomHpnl.add( getPanel( feed.getTitle(), feed.getComment(), feed.getIcon(), i, true ) );
							}
							i++;
						}
					}
					//Changed by Prasad on 14/09/19 [menn panel related ui changes] END

					vPanel.clear();
					vPanel.add( topHpnl );
					vPanel.add( bottomHpnl );
					vPanel.add( middleHpnlOuter );

					//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
					/*img.addDomHandler(new ClickHandler()
					{
						@Override
						public void onClick(ClickEvent event)
						{
							E12CommonUtils.printOnConsole("inside slideMenuImage click handler");
							getApplicationsInfo(middleHpnl, middleHpnlOuter);
						}
					}, ClickEvent.getType());*/
					//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end

					createSlideMenuPanel();
				}
			});
			//Changed by Sandeep S. on 20-MAR-18 [local storage & indexed db related changes] end
		}
		else
		{
			E12CommonUtils.printOnConsole("316 ------inside else ");
			createSlideMenuPanel();
		}
	}

	private E12Feed getBlankFeed()
	{
		String dashboard = E12Constants.constants.setDashboardLbl();

		E12Feed dummyFeed = new E12Feed();
		dummyFeed.setTitle( dashboard);
		dummyFeed.feedTitle =dashboard;
		dummyFeed.comment = "";
		dummyFeed.icon = "dashboardImg";

		return dummyFeed;
	}
	//	ArrayList<String> featuresList = new ArrayList<String>();
	private List<String> featuresList = new ArrayList<String>();
	/**
	 * This method creates footer options in slide menu panel
	 */
	private void createOptionsList()
	{
		try
		{
			featuresList.clear();
			String featuresStr = E12Global.checkNull( E12Constants.featureOptions );
			E12CommonUtils.printOnConsole(" featuresStr ["+featuresStr+"]");
			if( featuresStr.trim().length() > 1 )
			{
				String [] featuresArray = featuresStr.split("~");
				featuresList = Arrays.asList( featuresArray );
			}
			String explore = E12Constants.constants.setE12ExplorerLbl();
			String workflow = E12Constants.constants.setWorkflowLbl();
			String dashboard = E12Constants.constants.setDashboardLbl();
			String social = E12Constants.constants.setBulletinBoardLbl();
			featuresMap.clear();
			/*
			 * Changed by Pravin K  on 20-FEB-18 [to hide workflow and social] START
			 * in ibase.xml 'feature' node add  with 'enable' attribute
			 * if the enable = "NO" only then Social or Workflow will hide.
			 * Cases to show the icons(Social or Workflow)
			 * 1> If feature node added
			 * 2> If feature node added with enable='YES'
			 * 3> If feature node not added
			 *
			 *     Old code
			 * if(featuresList.contains("W") || featuresList.isEmpty())
			 */
			if( ! featuresList.contains("E:NO") || featuresList.isEmpty())
			{
				E12Feed feed4 = new E12Feed();
				feed4.setTitle(explore);
				feed4.feedTitle = explore;
				feed4.comment = "";
				feed4.icon = "vision-ui-explore";
				featuresMap.put(1+"", feed4);
			}
			if( ! featuresList.contains("W:NO") || featuresList.isEmpty())
			{
				E12Feed feed = new E12Feed();
				feed.setTitle(workflow);
				feed.feedTitle = workflow;
				feed.comment = "";
				feed.icon = "vision-ui-workflow";
				featuresMap.put(2+"", feed);
			}
			if( ! featuresList.contains("S:NO") || featuresList.isEmpty())
			{
				E12Feed feed3 = new E12Feed();
				feed3.setTitle(social );
				feed3.feedTitle = social;
				feed3.comment = "";
				feed3.icon = "vision-ui-social";
				featuresMap.put(3+"", feed3);
			}
			if( ! featuresList.contains("D:NO") || featuresList.isEmpty() )
			{
				E12Feed feed2 = new E12Feed();
				feed2.setTitle( dashboard);
				feed2.feedTitle =dashboard;
				feed2.comment = "";
				feed2.icon = "vision-ui-home";
				featuresMap.put(4+"", feed2);
			}
			//Changed by Pravin K  on 20-FEB-18 [to hide workflow and social] END
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception while creating footer options ["+e.getMessage()+"]");
		}
	}

	public Widget getPanel( final String title, String comment, String icon, int position, boolean visible )
	{
		PanelLabel panelLabel = null;
		HTML footerHtmlData = null;
		try
		{
			E12CommonUtils.printOnConsole("### 368 getpanel e12Options panel ["+title+"]--icon ["+icon+"]");
			if( title.equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
			{
				footerHtmlData = new HTML("<div style='text-align: -webkit-center;height: 40px;width: 40px;padding: 5px;right: 0;position: absolute;'>"
						+ "<div class='"+icon+" deSelectMenu dashBoardIcon'></div>"
						+ "</div>");
				//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[Start]
				if(DeviceOS.iOS == E12Global.getInstance().getDeviceOS())
				{
				  if(Window.Navigator.getPlatform().equalsIgnoreCase("iphone"))
				  {
					  if(Window.getClientHeight() > 800 && Window.getClientWidth() > 370)
					  {
						  footerHtmlData.getElement().getStyle().setPaddingTop(20, Unit.PX);
					  }
				  }
				}
				//Added by sunny soni for iphone11 ui related change i.e notch design in ios ui change[Start][End]

				footerHtmlData.addClickHandler(new ClickHandler() {

					@Override
					public void onClick(ClickEvent event) {

						E12CommonUtils.printOnConsole("Clicked on option -- ["+title+"]");
						E12OptionsPanel e12OptionsPanel = new E12OptionsPanel( "", null );
						slidePopupPnl.hide();
						e12OptionsPanel.optionSelected(title);
					}
				});

				return footerHtmlData;
			}

			HorizontalPanel completeHoriPanel = new HorizontalPanel();
			completeHoriPanel.getElement().setId("title-"+title);

			String className = icon +" imageIcon menuOption";
			if( title.equalsIgnoreCase( E12Constants.constants.setE12ExplorerLbl() ) )
			{
				className += " selectedMenu";
			}

			//HTML favIconTextHtml1 = new HTML( "<HTML><TABLE><TR><TD class='"+icon+"Slide'> </TD></TR></TABLE></HTML>" );
			//HTML favIconTextHtml2 = new HTML( "<HTML><TABLE id='s11' class='menuTitleOption' ><TR><TD VALIGN='bottom'><span class='E12favourite-list-slideMenu'>" + title + "</span></TD> </TR> <TR> <TD VALIGN='top'><span class='E12favourite-list-slideMenu'>" + /*entry.getComment() +*/"</span></TD> </TR></TABLE></HTML>" );
			//HTML favIconTextHtml2 = new HTML( "<HTML><TABLE id='s11' class='menuTitleOption' ><TR><TD VALIGN='bottom'><span class='E12favourite-list-slideMenu'>" + title + "</span></TD> </TR> </TABLE></HTML>" );
			footerHtmlData = new HTML("<div>"
					+ "<div style='text-align: -webkit-center;'>"
					+ "<div class='"+className+"' title='"+ title +"'></div>"
					+ "</div>"
					+ "<figcaption class = 'figCaption'>"+ title +"</figcaption>"
					+ "</div>");

			completeHoriPanel.add( footerHtmlData );
			panelLabel = new PanelLabel( completeHoriPanel, new Command() {

				public void execute() {

					E12CommonUtils.printOnConsole( "Clicked on option ["+ title +"]" );
					String selectedOption = getSelectedMenuOption();
					if ( ! selectedOption.equalsIgnoreCase( title ) )
					{
						setMenuOptionSelected( title );

						if( ! title.equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
						{
							menuContentPanel.clear();
							exploreOptions.setVisible( false );
						}
						if( title.equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) || title.equalsIgnoreCase( E12Constants.constants.setWorkflowLbl() ) )
						{
							E12OptionsPanel e12OptionsPanel = new E12OptionsPanel( "", null );
							slidePopupPnl.hide();
							e12OptionsPanel.optionSelected( title );
						}
						else
						{
							setExplorerOpen( false );
							setFavouriteOpen( false );
							setAssistantOpen( false );

							if( title.equalsIgnoreCase( E12Constants.constants.setBulletinBoardLbl() ) )
							{
								getSocialPanel();
							}
							else if( title.equalsIgnoreCase( E12Constants.constants.setE12ExplorerLbl() ) )
							{
								exploreOptions.setVisible( true );
								setExplorerOpen( true );

								E12ExplorerPanel e12ExplorerPanel = null;
								//e12ExplorerPanel = ( E12ExplorerPanel ) E12Global.getInstance().getPanel("M_E12Explorer");
								E12CommonUtils.printOnConsole("e12SlideMenuPanel.middleHpnlOuter "+e12ExplorerPanel);
								if( e12ExplorerPanel == null )
								{
									e12ExplorerPanel = new E12ExplorerPanel("Explorer", null, menuContentPanel, exploreDetailPathPanel, true, E12Global.getInstance().getRedirectPath() );
								}
							}
						}
					}
				}
			});

			String socialOpt = E12Constants.social_opt;
			E12CommonUtils.printOnConsole("social opt: ["+socialOpt+"]");
			panelLabel.setText( title );
			panelLabel.getElement().setId( "Panel-"+title );
			position = position * 30;
			String leftCss = "";
			if( position == 60 )
			{
				//leftCss = "left : "+position+"%; padding-left: 15%;";
				leftCss = "left : "+position+"%;";
			}
			else
			{
				leftCss = "left : "+position+"%;";
			}
			E12CommonUtils.printOnConsole("842 : leftCss -- ["+leftCss+"]");
		
			if( ! title.equalsIgnoreCase( E12Constants.constants.setDashboardLbl() ) )
			{
				panelLabel.getElement().setAttribute("style", leftCss );
				panelLabel.setStyleName( "menuOptionsPanel" );
				
				if(socialOpt != null && !socialOpt.isEmpty() && socialOpt.equals("0") && title.equalsIgnoreCase("Social"))
				{
					panelLabel.getElement().getStyle().setProperty("pointer-events", "none");
				    panelLabel.getElement().getStyle().setProperty("visibility", "hidden");
				}
			}
			panelLabel.setVisible( visible );
		}
		catch (Exception e)
		{
			Window.alert("Exception : getPanel() :"+e.getMessage());
			e.printStackTrace();
		}
		return panelLabel;
	}

	/*@Override
	protected String getShortTitle() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void redirect(String toRedirectPath, String data) {
		// TODO Auto-generated method stub

	}

	@Override
	protected void createOptionsPanel(String labelText) {
		// TODO Auto-generated method stub

	}*/

	public static class E12Feed
	{
		String feedTitle = "";
		String comment = "";
		String icon = "";
		public  String getTitle()
		{
			return feedTitle;
		}

		public  String getUrl()
		{
			return "";
		}

		public  void setTitle( String title )
		{
			feedTitle = title;
		}

		/**
		 * @return the comment
		 */
		public String getComment() {
			return comment;
		}

		/**
		 * @return the icon
		 */
		public String getIcon() {
			return icon;
		}

	}

	public class CustomPopUp extends PopupPanel
	{
		HandlerRegistration handlerRegistration=null;
		public com.google.gwt.dom.client.Element getGlassElement() {
			// TODO Auto-generated method stub
			return super.getGlassElement();
		}
		@Override
		protected void onLoad() {
			super.onLoad();
			handlerRegistration=Window.addResizeHandler(new ResizeHandler()
			{
				@Override
				public void onResize(ResizeEvent event)
				{
					int clientWidth=Window.getClientWidth();
					int left = (clientWidth/100)*80;
					E12CommonUtils.printOnConsole("slide panel clientWidth["+clientWidth+"]");
					E12CommonUtils.printOnConsole("slide panel left["+left+"]");
					//CustomPopUp.this.getElement().setAttribute("style", "left:"+-left+"px !important;");
					/*//Added by Amey W. [ To resolve side panel issue while rotate screen ] on 31-1-2020
					hidePnl();*/
					//String slideoutCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(-"+(Window.getClientWidth() - 44)+"px);"+"transform: translateX(-"+(Window.getClientWidth() - 44)+"px);";
					//CustomPopUp.this.getElement().setAttribute( "style", slideoutCss );
				}
			});
		}

		@Override
		protected void onUnload() {
			super.onUnload();
			handlerRegistration.removeHandler();
		}

	}

	private String deviceType()
	{
		String deviceType = "Other";
		try
		{
			if ( Window.Navigator.getPlatform().indexOf( "iPhone" ) != -1 )
			{
				deviceType= "iPhone";
			}
			else if ( Window.Navigator.getPlatform().indexOf( "iPad" ) != -1 )
			{
				deviceType = "iPad";
			}
			else if ( Window.Navigator.getUserAgent().indexOf("Android") != -1 )
			{
				if( Window.Navigator.getUserAgent().indexOf("Mobile") != -1)
				{
					deviceType = "Mobile";
				}
				else
				{
					deviceType = "Tablet";
				}
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception while deviceType ["+e.getMessage()+"]");
		}
		return deviceType;
	}

	int xStart = 0;
	int yStart = 0;
	/**
	 * In this method slide menu popup is created.
	 */
	public void createSlideMenuPanel()
	{
		//slidePopupPnl = new PopupPanel();
		if( slidePopupPnl == null )
		{
			E12CommonUtils.printOnConsole("457 --- panel is null");
			slidePopupPnl = new CustomPopUp();
			slidePopupPnl.clear();
			slidePopupPnl.getElement().setId("e12SlideMenuPopupPnl-"+E12Constants.userID);
			slidePopupPnl.setStyleName("menuSlidePopupPanelbase");
			slidePopupPnl.addStyleName( "menuSlidePopupPanel" );
			slidePopupPnl.setAutoHideEnabled(false);
			slidePopupPnl.setGlassEnabled(true);
			slidePopupPnl.setGlassStyleName("menuSlidePopupPanelGlass");
			//Changed By Ravindra C on  24-02-20 for iphone button display related changes 
			slidePopupPnl.setHeight(Window.getClientHeight()+"px");

			vPanel.setHeight(Window.getClientHeight() + "px");
			vPanel.getElement().setAttribute("style", "width: 100%;overflow: auto;");
			//vPanel.setWidth( Window.getClientWidth() - 44 + "px" );

			slidePopupPnl.add(vPanel);
			slidePopupPnl.setHeight(Window.getClientHeight() - 10 + "px");

			//if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS && "iPad".equalsIgnoreCase(deviceType()) )
			//{
			//slidePopupPnl.setWidth( getPercentWidth(40) + "px" );
			//}

			slidePopupPnl.addDomHandler(new TouchStartHandler() {

				@Override
				public void onTouchStart(TouchStartEvent event) {
					Touch touch = event.getTouches().get(0);
					xStart = touch.getClientX();
					yStart = touch.getClientY();
					E12CommonUtils.printOnConsole("inside touch start 529 xStart ["+xStart+"] and yStart ["+yStart+"]");

				}
			}, TouchStartEvent.getType());

			slidePopupPnl.addDomHandler(new TouchMoveHandler() {

				@Override
				public void onTouchMove(TouchMoveEvent event) {
					Touch touch = event.getTouches().get(0);
					int moveX =  xStart - touch.getClientX();
					int moveY =  yStart - touch.getClientY();
					E12CommonUtils.printOnConsole("inside touch move 543  xStart ["+xStart+"] and move moveX is ["+moveX+"]");
					E12CommonUtils.printOnConsole("inside touch move 543  yyyyyy yStart ["+yStart+"] and move moveY is ["+moveY+"] ");
					if(slidePopupPnl.isShowing())
					{
						if( moveX > 15 && moveY < 10 && moveY > 0 )
						{
							E12CommonUtils.printOnConsole("********550 current MoveY ["+moveY+"] moveX ["+moveX+"]");
							hidePnl();
						}
					}
				}
			}, TouchMoveEvent.getType());

			Window.addResizeHandler( new ResizeHandler() {

				@Override
				public void onResize(ResizeEvent event) {

					//slidePopupPnl.setHeight("");
					vPanel.setHeight(Window.getClientHeight() + "px");
				}
			});

			//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
			//E12CommonUtils.getInstance().setSlidePopupPnl( slidePopupPnl );
			String key = E12Constants.userID +"-"+E12Constants.conApplNm;
			E12CommonUtils.getInstance().setSlidePopupPnl( key, slidePopupPnl );
			//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
			slidePopupPnl.show();

			Timer t = new Timer() {

				@Override
				public void run() {
					E12CommonUtils.printOnConsole("calling javascript touched *************");
					addTouchHandler( slidePopupPnl.getGlassElement(), slidePopupPnl.getElement() );
				}
			};
			t.schedule(400);

			//applyHeadRoomEffect("middleHpnl", "topHpnl", 5, 150);
			//	int offset = getPercentHeight( 25 );
			//e12SlideMenuHeadRoomObj = applyHeadRoomEffect("middleHpnlOuter", "topHpnl", 5, 100);
			e12SlideMenuHeadRoomObj = E12CommonUtils.getInstance().applyHeadRoomEffect("middleHpnlOuter", "topHpnl", 5, 100 );
			//E12CommonUtils.getInstance().applyHeadRoomEffectFooter("middleHpnlOuter", "bottomHpnl", 5, 100 );
			E12CommonUtils.getInstance().setE12SlideMenuHeadRoomObj(e12SlideMenuHeadRoomObj);

			//menuPanelMap.put(E12Constants.userID, slidePopupPnl);
		}
		else
		{
			E12CommonUtils.printOnConsole("524 -----SlideMenu is not null and is showing or not ["+slidePopupPnl.isShowing()+"] visible ["+slidePopupPnl.isVisible()+"]");
			E12CommonUtils.printOnConsole("567 menuPanelmap  and current user is ["+E12Constants.userID+"]");
			slidePopupPnl.setGlassEnabled(true);
			slidePopupPnl.getGlassElement().removeClassName("menuSlidePopupPanelGlassReset");
			slidePopupPnl.getGlassElement().addClassName("menuSlidePopupPanelGlass");
			slidePopupPnl.addStyleName( "menuSlidePopupPanel" );
			//String transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translate3D(0px, 0px, 0px); transform: translate3D(0px, 0px, 0px);";
			//String transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(0px); transform: translateX(0px);";
			String transCss = "-webkit-transition: left 600ms;transition: left 600ms; left: 0px !important;";
			slidePopupPnl.getElement().setAttribute("style", transCss );
			slidePopupPnl.setHeight(Window.getClientHeight() - 10 + "px");
			//if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS && "iPad".equalsIgnoreCase(deviceType()) )
			//{
			//	slidePopupPnl.setWidth( getPercentWidth(40) + "px" );
			//}

			//Added by Vikas L on 7-March-19 [ to resolve side panel issue in case of iPhone] start
			String padding="";
			if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS )
			{
				if( "iPad".equalsIgnoreCase(deviceType()) )
				{
					padding = "padding-top: "+getPercentHeight(15)+"px;";
				}
				else
				{
					E12CommonUtils.printOnConsole("iPhone css padding!!");
					//Commented by Sainath T. on 16-SEP-2019 [To resolve ui related issue in iPhone]
					//padding = "padding-top: "+getPercentHeight(25)+"px;";
				}
				vPanel.getWidget(1).getElement().setAttribute("style", padding);
			}
			//Added by Vikas L on 7-March-19 [to resolve side panel issue in case of iPhone] end
			//
			slidePopupPnl.show();

			Timer t = new Timer() {

				@Override
				public void run() {
					E12CommonUtils.printOnConsole("calling javascript touched *************");
					addTouchHandler( slidePopupPnl.getGlassElement(), slidePopupPnl.getElement() );
				}
			};
			t.schedule(400);

			e12SlideMenuHeadRoomObj = E12CommonUtils.getInstance().applyHeadRoomEffect("middleHpnlOuter", "topHpnl", 5, 100 );
			E12CommonUtils.getInstance().setE12SlideMenuHeadRoomObj(e12SlideMenuHeadRoomObj);
		}
	}

	private int getPercentHeight( int percent )
	{
		int height = 0;
		int winHeight = Window.getClientHeight();
		try
		{
			height = (winHeight * percent)/ 100 ;
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception while get percent ["+e.getMessage()+"]");
		}

		return height;
	}

	private int getPercentWidth( int percent )
	{
		int width = 0;
		int winWidth = Window.getClientWidth();
		try
		{
			width = (winWidth * percent)/ 100 ;
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception while get percent ["+e.getMessage()+"]");
		}

		return width;
	}

	public void hidePnl()
	{
		if( slidePopupPnl != null )
		{
			slidePopupPnl.removeStyleName("menuSlidePopupPanel");
			//			slidePopupPnl.setStyleName("menuSlidePopupPanelOut");
			String slideoutCss = "";
			if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS )
			{
				slideoutCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(-"+(Window.getClientWidth() - 44)+"px);"+"transform: translateX(-"+(Window.getClientWidth() - 44)+"px);";
			}
			else
			{
				slideoutCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(-"+(Window.getClientWidth() - 44)+"px);"+"transform: translateX(-"+(Window.getClientWidth() - 44)+"px);";
			}

			//String slideoutCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translate3D(-"+(Window.getClientWidth() - 44)+"px, 0px, 0px);"+"transform: translate3D(-"+(Window.getClientWidth() - 44)+"px, 0px, 0px);";
			slidePopupPnl.getElement().setAttribute("style", slideoutCss);

			Timer t = new Timer() {

				@Override
				public void run() {
					//slidePopupPnl.hide();
					//slidePopupPnl.setGlassEnabled(false);
					slidePopupPnl.getGlassElement().removeClassName("menuSlidePopupPanelGlass");
					slidePopupPnl.getGlassElement().setClassName("menuSlidePopupPanelGlassReset");
					//slidePopupPnl.removeStyleName("menuSlidePopupPanelGlass");
					//E12CommonUtils.getInstance().setSlidePopupPnl(slidePopupPnl);
					E12CommonUtils.getInstance().removeHeadroomEffect( E12CommonUtils.getInstance().getE12SlideMenuHeadRoomObj() );
					//menuPanelMap.put(E12Constants.userID, slidePopupPnl);
				}
			};
			t.schedule(100);

		}
	}

	public void closeSlidePopup()
	{
		Timer t = new Timer() {

			@Override
			public void run() {
				E12CommonUtils.printOnConsole("E12SlideMenu : 530 finally closed");
				//slidePopupPnl.hide();
				//slidePopupPnl.getGlassElement().removeFromParent();
				slidePopupPnl.getGlassElement().removeClassName("menuSlidePopupPanelGlass");
				slidePopupPnl.getGlassElement().setClassName("menuSlidePopupPanelGlassReset");
				//slidePopupPnl.setGlassEnabled(false);
				//slidePopupPnl.removeStyleName("menuSlidePopupPanelGlass");

				//E12CommonUtils.getInstance().setSlidePopupPnl(slidePopupPnl);
				E12CommonUtils.getInstance().removeHeadroomEffect( E12CommonUtils.getInstance().getE12SlideMenuHeadRoomObj() );
				//menuPanelMap.put(E12Constants.userID, slidePopupPnl);
				//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
				if( isClick )
				{
					String curAppl = E12Constants.conApplNm;
					String curUserId = E12Constants.userID;
					try
					{
						String key = curUserId +"-"+curAppl;
						E12SlideMenuPanel.getInstance( key ).slidePopupPnl.hide();
						E12CommonUtils.printOnConsole("closeSlidePopup 1130: "+key);
						isClick = false;
						E12SlideMenuPanel.getInstance( key ).menuPanelMap.remove( key );

					}
					catch (Exception e)
					{
						E12CommonUtils.printOnConsole("Exception closeSlidePopup ["+e.getMessage()+"]");
					}
				}
				//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
			}
		};
		t.schedule(100);
	}

	public native void addTouchHandler( Element outerGlassElement, Element slidePopupElement )
	/*-{
		try {
    			var that = this;
    			console.log('received element --'+outerGlassElement);
		    	var startx = 0;

				outerGlassElement.addEventListener("touchstart", function( e ){

					var touchobj = e.changedTouches[0];
		        	startx = parseInt(touchobj.clientX);
		        	console.log('touch start -- '+startx);
//		        	var transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);"+"transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);";
// 					slidePopupElement.setAttribute("style", transCss );
//		        	var abc = that.@ibase.e12ria.client.E12SlideMenuPanel::closeSlidePopup()();

				});

				outerGlassElement.addEventListener("touchend", function( e ){

					var touchobj = e.changedTouches[0];
		        	var startEndx = parseInt(touchobj.clientX);
		        	console.log('touch start on end -- '+startEndx);
		        	//var transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);"+"transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);";
		        	//var transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(-"+(slidePopupElement.clientWidth)+"px);"+"transform: translateX(-"+(slidePopupElement.clientWidth)+"px);";
		        	var transCss = "-webkit-transition:left 600ms;transition:left 600ms; left:-"+(slidePopupElement.clientWidth)+"px !important;";
   					slidePopupElement.setAttribute("style", transCss );
		        	var abc = that.@ibase.e12ria.client.E12SlideMenuPanel::closeSlidePopup()();
				});

				outerGlassElement.addEventListener("touchmove", function( e ){

					var touchobj = e.changedTouches[0];

		        	var dist = parseInt(touchobj.clientX) - startx;

		        	if( Math.abs(dist)> 15 )
		        	{
		        		//var transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);"+"transform: translate3D(-"+(slidePopupElement.clientWidth)+"px, 0px, 0px);";
		        		//var transCss = "transition: transform 600ms;-webkit-transition: -webkit-transform 600ms; -webkit-transform: translateX(-"+(slidePopupElement.clientWidth)+"px);"+"transform: translateX(-"+(slidePopupElement.clientWidth)+"px);";
		        		var transCss = "-webkit-transition: left 600ms;transition: left 600ms; left:-"+(slidePopupElement.clientWidth)+"px !important;";
   						slidePopupElement.setAttribute("style", transCss );
   						var abc = that.@ibase.e12ria.client.E12SlideMenuPanel::closeSlidePopup()();
		        	}

		        	console.log('touch move -- '+dist);
				});

				outerGlassElement.addEventListener("touchcancel", function( e ){

				});

		}
		catch(err)
		{
			console.log('Exception --'+err.message);
		}

	}-*/;

	/**
	 * Apply head room effect.
	 */
	//	protected native JavaScriptObject applyHeadRoomEffect(String scrollerId, String subHeaderId, int tolerance, int offset)/*-{
	//		try {
	//			var scrollerElement = $doc.getElementById(scrollerId);
	//			var options = {
	//scroller: scrollerElement,
	//tolerance: tolerance,
	//          	offset : offset,
	//          	classes: {
	//          		initial: "animated",
	//              	pinned: "slideDown",
	//              	unpinned: "slideUpMenu"
	//         		}
	//      	};
	//
	//			var header = new $wnd.Headroom($doc.getElementById(subHeaderId), options);
	//      	header.init();
	//      	return header;
	//		} catch (ex) {
	//			 console.log('Exception In applyHeadRoomEffect : ' + ex);
	//		}
	//	}-*/;

	/**
	 * For removing subheader and headroom effect from WallToWallPanel.
	 */
	//	public void removeSubHeader()
	//	{
	//		if (subHeaderId.equals(flowPanel.getWidget(1).getElement().getId())) {
	//			subHeaderAttachHandler.removeHandler();
	//			// Make some delay for removing attach handler of sub header panel
	//			Timer timer = new Timer() {
	//@Override
	//public void run() {
	//flowPanel.remove(1);
	//removeHeadroomEffect(headRoomObj);
	//int contentTop = outerHeaderPanel.getOffsetHeight();
	//contents.getElement().getStyle().setPaddingTop(contentTop, Unit.PX);
	//}
	//			};
	//			timer.schedule(1);
	//		}
	//	}
	//
	/**
	 * Called headroom object destroy() method for removing headroom effect.
	 *
	 * @param headRoomObj Headroom object.
	 */
	//	protected native void removeHeadroomEffect(Object headRoomObj) /*-{
	//		try {
	//			if (headRoomObj != null)
	//				headRoomObj.destroy();
	//		} catch (ex) {
	////			window.alert('Exception when removing headroom effect : ' + ex);
	//		}
	//	}-*/;
	// Added by Abhishek to add subheader and applying head room effect END

	public boolean isFavouriteOpen() {
		return isFavouriteOpen;
	}

	public void setFavouriteOpen(boolean isFavouriteOpen)
	{
		this.isFavouriteOpen = isFavouriteOpen;

		if ( isFavouriteOpen )
		{
			favouriteLbl.addStyleName("btnSelect");
			favouriteLblIcon.addStyleName("btnSelect");

			showAllLbl.addStyleName("btnDeselect");
			showAllLblIcon.addStyleName("btnDeselect");

			assistantLbl.addStyleName("btnDeselect");
			assistantLblIcon.addStyleName("btnDeselect");

			favouriteLbl.removeStyleName("btnDeselect");
			favouriteLblIcon.removeStyleName("btnDeselect");

			showAllLbl.removeStyleName("btnSelect");
			showAllLblIcon.removeStyleName("btnSelect");

			assistantLbl.removeStyleName("btnSelect");
			assistantLblIcon.removeStyleName("btnSelect");
		}
	}

	public boolean isExplorerOpen()
	{
		return isExplorerOpen;
	}

	public void setExplorerOpen(boolean isExplorerOpen)
	{
		this.isExplorerOpen = isExplorerOpen;

		if ( isExplorerOpen )
		{
			showAllLbl.addStyleName("btnSelect");
			showAllLblIcon.addStyleName("btnSelect");

			favouriteLbl.addStyleName("btnDeselect");
			favouriteLblIcon.addStyleName("btnDeselect");

			assistantLbl.addStyleName("btnDeselect");
			assistantLblIcon.addStyleName("btnDeselect");

			showAllLbl.removeStyleName("btnDeselect");
			showAllLblIcon.removeStyleName("btnDeselect");

			favouriteLbl.removeStyleName("btnSelect");
			favouriteLblIcon.removeStyleName("btnSelect");

			assistantLbl.removeStyleName("btnSelect");
			assistantLblIcon.removeStyleName("btnSelect");
		}
	}

	/**
	 * @return the isAssistantOpen
	 */
	public boolean isAssistantOpen()
	{
		return isAssistantOpen;
	}

	/**
	 * @param isAssistantOpen the isAssistantOpen to set
	 */
	public void setAssistantOpen(boolean isAssistantOpen)
	{
		this.isAssistantOpen = isAssistantOpen;

		if ( isAssistantOpen )
		{
			assistantLbl.addStyleName("btnSelect");
			assistantLblIcon.addStyleName("btnSelect");

			showAllLbl.addStyleName("btnDeselect");
			showAllLblIcon.addStyleName("btnDeselect");

			favouriteLbl.addStyleName("btnDeselect");
			favouriteLblIcon.addStyleName("btnDeselect");

			assistantLbl.removeStyleName("btnDeselect");
			assistantLblIcon.removeStyleName("btnDeselect");

			showAllLbl.removeStyleName("btnSelect");
			showAllLblIcon.removeStyleName("btnSelect");

			favouriteLbl.removeStyleName("btnSelect");
			favouriteLblIcon.removeStyleName("btnSelect");
		}
	}

	public native void log(Object o)/*-{
		console.log(o)
	}-*/;

	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
	//Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
	public PanelLabel addPanel(String imgClassName, final String descrName, final String appName, final String curAppName, final String userName, final FlowPanel middleHpnl, final FlowPanel middleHpnlOuter, final String feedDOMId, String groupName, int index,final String applicationGroup)
	{
		//Changed by Sainath T.on 10-OCT-2019[To set the new icons]-Start
		String imgName = E12Global.checkNull(appName).trim() +"wht.png";
		//String serverURL = E12Global.getHostUrl() +"/ibase/images/apps/" + imgName ;
		String serverURL = E12Global.getHostUrl() +"/ibase/images/galaxy/" + imgName ;
		E12CommonUtils.printOnConsole( "\n E12SlideMenuPanel serverURL["+serverURL+"]" );

		if ( ! E12Global.getInstance().isHostedMode() && ! E12Global.getInstance().isOffline() )
		{
			E12CommonUtils.getInstance().downloadMenuImage( imgName, "", serverURL, new Callback<Boolean, Boolean>()
			{
				@Override
				public void onSuccess(Boolean isDownload ){
				}
				@Override
				public void onFailure(Boolean reason){
				}
			} );
		}

		E12CommonUtils.printOnConsole( "appName["+appName+"] imgClassName["+imgClassName+"] descrName["+descrName+"]" );
		String errorStr = serverURL.substring(0,serverURL.lastIndexOf("/")+1);
		errorStr = errorStr + "errMenuwht.png";
		//HTML favIconTextHtml1 = new HTML( "<HTML><TABLE><TR><TD class='"+imgClassName+"'> </TD></TR></TABLE></HTML>" );
		HTML favIconTextHtml1 = new HTML( "<HTML><TABLE cellspacing='0' cellpadding='0'><TR><TD > <div style='background-color:"+E12Constants.applColor+"' class='favaAndOptionMenuImg'><img onerror='this.src=\""+errorStr+"\"' class='menuImg favaAndOptionMenuImage' src='"+serverURL+"'/></div></TD></TR></TABLE></HTML>" );
		HTML favIconTextHtml2 = new HTML( "<HTML><TABLE cellspacing='0' cellpadding='0' style= 'padding: 5px 8px;' ><TR><TD VALIGN='bottom' ><span class='appfeedStyle'>" + descrName + "</span></TD> </TR> <TR> <TD VALIGN='top'><span class='subfeedStyle'>" + "" + "</span></TD> </TR></TABLE></HTML>" );
		//Changed by Sainath T.on 30-SEP-2019[To set the new icons]-End
		HorizontalPanel hortPanel = new HorizontalPanel();
		hortPanel.add( favIconTextHtml1 );
		hortPanel.add( favIconTextHtml2 );
		hortPanel.setWidth("100%");
		//Changed by Sainath T.on 30-SEP-2019[To set the new icons]
		hortPanel.setCellWidth(favIconTextHtml1, "32px"); //55px
		try {
			panelLabel = new PanelLabel(hortPanel, new Command() {


				@Override
				public void execute() {
					//E12Constants.conApplNm = appName;
					E12CommonUtils.printOnConsole("inside E12SlideMenuPanel addPanel for "+feedDOMId);
					E12CommonUtils.printOnConsole("inside E12SlideMenuPanel addPanel for app "+appName);
					//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ] Start
					E12Constants.applicationGroup = applicationGroup;
					E12Constants.applDescr = descrName;
					//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ] End
					//Added by Sainath T.on 30-SEP-2019[To set the new icons]
					slidePopupPnl.removeStyleName("MenuSlidePopupPanelColor");
					drawNoOfSites(userName, middleHpnl, middleHpnlOuter, feedDOMId);
				}
			});

		} catch (Exception e) {
			Window.alert("Exception in addPanel[+"+e.getMessage()+"]");
			isClick = false;
		}
		panelLabel.getElement().setId( feedDOMId );
		//Added by Sainath T.on 30-SEP-2019[To set the new icons]
		panelLabel.getElement().addClassName(groupName+"_appl_grp");
		E12CommonUtils.printOnConsole("index>>"+index);
		panelLabel.getElement().addClassName("applNamePanelLable");
		String applClass = index == 1? "applGrpShow" : "applGrpHide";
		panelLabel.getElement().addClassName( applClass );
		//Changed by Sainath T.on 30-SEP-2019[To set the new icons]-End
		if( appName.equalsIgnoreCase(curAppName) )
		{
			panelLabel.getElement().getStyle().setBackgroundColor("#F9F9E0");
			panelLabel.setCommand(null);
		}
		return panelLabel;
	}

	protected void drawNoOfSites( final String userName, final FlowPanel middleHpnl, final FlowPanel middleHpnlOuter, final String selectedApplication )
	{
		try
		{
			String key = userName + "/GET_SITES";
			E12Storage.getItem(key, new Callback<String, String>() {

				@Override
				public void onSuccess(String result)
				{
					String xmlData = result;
					if( xmlData.length() > 0 )
					{
						/*Document document = XMLParser.parse( xmlData );
						XMLParser.removeWhitespace(document);

						if( document != null && document.hasChildNodes() )
						{
							PanelLabel selectedApp = getPanelLabel(middleHpnl, selectedApplication);
							HTML favIconTextHtml3 = new HTML( "<HTML><TABLE><TR><TD class='appSwitch'> </TD></TR></TABLE></HTML>" );
							favIconTextHtml3.addDomHandler(new ClickHandler() {

								@Override
								public void onClick(ClickEvent event)
								{
									E12CommonUtils.printOnConsole("inside appSwitch");
									getApplicationsInfo(middleHpnl, middleHpnlOuter);

								}
							}, ClickEvent.getType());
							HorizontalPanel hortPanel = new HorizontalPanel();

							middleHpnl.clear();
							E12Search e12Search = new E12Search();
							e12Search.setStyleName("applicationSearchBar");
							SimplePanel innerDiv = new SimplePanel();
							innerDiv = (SimplePanel) e12Search.searchTextBox.getParent();
							if( innerDiv != null )
							{
								innerDiv.setStyleName("applicationsearchboxform");
								e12Search.searchTextBox.setStyleName("applicationsearchtextbox");
								e12Search.searchTextBox.getElement().setPropertyString( "placeholder" , "Search login site" );
							}
							if( selectedApp != null )
							{
								selectedApp.setCommand(null);
								//middleHpnl.add( selectedApp );
								hortPanel.add( selectedApp );
								selectedApp.getElement().getStyle().setBorderStyle(BorderStyle.NONE);
								selectedApp.getElement().getStyle().setOverflow(Overflow.HIDDEN);
								hortPanel.add( favIconTextHtml3 );
								favIconTextHtml3.getElement().getStyle().setMarginTop(8, Unit.PX);
								//hortPanel.setWidth("100%");
								hortPanel.setCellWidth(favIconTextHtml3, "15%");
								hortPanel.addStyleName("appHorizonntab");
								middleHpnl.add( hortPanel );
							}
							middleHpnl.add( e12Search );

							NodeList siteCodesNL = document.getElementsByTagName( "SITES" ).item(0).getChildNodes();
							int lenght = siteCodesNL.getLength();
							if( lenght == 1 )
							{
								Node siteNode = siteCodesNL.item(0);
								String siteCode = siteNode.getAttributes().getNamedItem( "code" ).getNodeValue();
								String siteType = siteNode.getAttributes().getNamedItem( "siteType" ).getNodeValue();
								String profileId = siteNode.getAttributes().getNamedItem( "profileId" ).getNodeValue();
								String city = siteNode.getAttributes().getNamedItem( "city" ).getNodeValue();
								//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
								String enterprise = siteNode.getAttributes().getNamedItem( "ENTERPRISE" ).getNodeValue();
								String siteDescr = siteNode.getFirstChild().getNodeValue();
								//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-Start
								String fin_entity = siteNode.getAttributes().getNamedItem( "FIN_ENTITY" ).getNodeValue();
								String facility_code = siteNode.getAttributes().getNamedItem( "FACILITY_CODE" ).getNodeValue();
								//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-End
								String feedDOMId = "feed0";
								E12Constants.siteCode = siteCode;
								E12Constants.siteDescr = siteDescr;
								//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
								//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-Start
								//WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise);
								final WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, "", city, enterprise,fin_entity,facility_code);
								//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-End

								setNewApplicationInfo(selectedApplication, new Callback<Boolean, Boolean>() {

									@Override
									public void onFailure(Boolean reason) {
										isClick = false;

									}

									@Override
									public void onSuccess(Boolean result)
									{
										isClick = false;
										if( result )
										{
											closeSlidePopup();
											hidePnl();
											String key = E12Constants.userID +"-"+E12Constants.conApplNm;
											if( E12CommonUtils.getInstance().getSlidePopupPnl(key) != null )
											{
												E12CommonUtils.getInstance().getSlidePopupPnl(key).hide();
											}
											Timer t = new Timer() {

												@Override
												public void run() {
													E12CommonUtils.printOnConsole("E12SlideMenu : 530 finally closed");
													slidePopupPnl = null;
													meLogin.setSelectedSiteInfo( wrapSiteInfo );
												}
											};
											t.schedule(120);
										}

									}
								});
							}
							else if( lenght >= 2 )
							{
								HashMap< String, String > serachFeedMap = new HashMap< String, String >();
								for( int index = 0; index < lenght; index++ )
								{
									Node siteNode = siteCodesNL.item(index);
									String siteCode = siteNode.getAttributes().getNamedItem( "code" ).getNodeValue();
									String siteType = siteNode.getAttributes().getNamedItem( "siteType" ).getNodeValue();
									String profileId = siteNode.getAttributes().getNamedItem( "profileId" ).getNodeValue();
									String city = siteNode.getAttributes().getNamedItem( "city" ).getNodeValue();
									//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
									String enterprise = siteNode.getAttributes().getNamedItem( "ENTERPRISE" ).getNodeValue();
									String siteDescr = siteNode.getFirstChild().getNodeValue();
									//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-Start
									String fin_entity = siteNode.getAttributes().getNamedItem( "FIN_ENTITY" ).getNodeValue();
									String facility_code = siteNode.getAttributes().getNamedItem( "FACILITY_CODE" ).getNodeValue();
									//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-End
									String feedDOMId = "feed"+index;
									E12Constants.siteCode = siteCode;
									E12Constants.siteDescr = siteDescr;
									String imgClassName = "";
									if( "F".equalsIgnoreCase(siteType) )
									{
										imgClassName = "factoryIcon";
									}
									else if( "W".equalsIgnoreCase(siteType) )
									{
										imgClassName = "warehouseIcon";
									}
									else
									{
										imgClassName = "officeIcon";
									}
									serachFeedMap.put(feedDOMId, siteDescr);
									//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
									//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-Start
									//WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise);
									WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise,fin_entity,facility_code);
									//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-End
									middleHpnl.add( addFeedPanel(wrapSiteInfo, selectedApplication) );
								}
								e12Search.setSearchFeedMap( serachFeedMap );
							}
							else
							{
								Window.alert( E12Constants.constants.setMsgNoSite() );
								isClick = false;
							}
							Window.scrollTo(0, 0);
							middleHpnl.getElement().setScrollTop(0);
						}*/
						drawNoofSites(xmlData, middleHpnl, middleHpnlOuter, selectedApplication);
					}
					//added by sunny soni for while not getting data from storage[Start]
					else
					{
						if(!E12Global.getInstance().isOffline())
						{
							HashMap<String, String> paramMap = new HashMap<String, String>();
							paramMap.put("userId", userName);
							paramMap.put("userLevel", E12Constants.userLevel);
							paramMap.put("ACTION", "GET_SITES");
							paramMap.put("FORM_NO", "0");
							//Added by sunny soni for getting login details map[start]
							paramMap.putAll(E12CommonUtils.getLoginDetailsMap());
							//Added by sunny soni for getting login details map[end]
							String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
							String path = E12Global.getHostUrl() + "/ibase/WebITMAuthenticateServlet?"+paramString;
							E12RequestBuilder requestBuilder = new E12RequestBuilder(RequestBuilder.GET, path);
							try
							{
								requestBuilder.sendRequest( "", new RequestCallback()
								{
									public void onResponseReceived(Request request, Response response)
									{
										boolean isNotError ;
										E12CommonUtils.printOnConsole("Inside response of drawNo Fo Connection ["+response.getText()+"]");
										if( "false".equalsIgnoreCase( response.getText() )  )
										{
											isNotError = false;
										}
										else
										{
											isNotError = E12Global.getInstance().checkErrorException( response,  0 );
										}
										if( isNotError )
										{
											String xmlData = E12Global.checkNull( response.getText() );

											xmlData = xmlData.replace("&", "&amp;"); //Added by Shivaji on 12-02-2015 TO handle xml parsing error in Mozilla
											//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] start
											String key = userName + "/GET_SITES";
											E12Storage.setItem(key, xmlData);
											//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
											if( xmlData.length() > 0 )
											{
												drawNoofSites(xmlData, middleHpnl, middleHpnlOuter, selectedApplication);
											}
										}

									}

									public void onError(Request request, Throwable exception) {
										Window.alert("Exception while launching no. of sites: " + exception.getMessage());
									}

								});


							}
							catch (RequestException re)
							{
								Window.alert("Exception in drawNoOfSites : " + re.getMessage() );
							}
						}
					}
					//added by sunny soni for while not getting data from storage[End]
				}

				@Override
				public void onFailure(String reason)
				{
					isClick = false;
				}
			});
		} catch (Exception e)
		{
			isClick = false;
			E12CommonUtils.printOnConsole("Exception in drawNoOfSites[+"+e.getMessage()+"]");
		}
	}

	public PanelLabel addFeedPanel( final WrapSiteInfo wrapSiteInfo , final String selectedApplication )
	{

		HTML favIconTextHtml1 = new HTML( "<HTML><TABLE><TR><TD class='"+wrapSiteInfo.getImgClassName()+"'> </TD></TR></TABLE></HTML>" );
		HTML favIconTextHtml2 = new HTML( "<HTML><TABLE><TR><TD VALIGN='bottom' ><span class='mainfeedStyle'>" + wrapSiteInfo.getSiteDescr() + "</span></TD> </TR> <TR> <TD VALIGN='top'><span class='subfeedStyle'>" + wrapSiteInfo.getCity()+" - "+ wrapSiteInfo.getSiteCode() + "</span></TD> </TR></TABLE></HTML>" );
		HorizontalPanel hortPanel = new HorizontalPanel();
		hortPanel.add( favIconTextHtml1 );
		hortPanel.add( favIconTextHtml2 );
		panelLabel = new PanelLabel(hortPanel, new Command()
		{
			@Override
			public void execute()
			{

				setNewApplicationInfo(selectedApplication, new Callback<Boolean, Boolean>() {

					@Override
					public void onFailure(Boolean reason) {
						isClick = false;

					}

					@Override
					public void onSuccess(Boolean result)
					{
						isClick = false;
						if( result )
						{
							closeSlidePopup();
							hidePnl();
							//E12CommonUtils.getInstance().getSlidePopupPnl().hide();
							String key = E12Constants.userID +"-"+E12Constants.conApplNm;
							if( E12CommonUtils.getInstance().getSlidePopupPnl(key) != null )
							{
								E12CommonUtils.getInstance().getSlidePopupPnl(key).hide();
							}
							Timer t = new Timer() {

								@Override
								public void run() {
									E12CommonUtils.printOnConsole("E12SlideMenu : 530 finally closed");
									slidePopupPnl = null;
									meLogin.setSelectedSiteInfo( wrapSiteInfo );
								}
							};
							t.schedule(120);
						}

					}
				});
			}
		});
		panelLabel.getElement().setId( wrapSiteInfo.getFeedDOMId() );
		return panelLabel;
	}

	private void drawMenubar(String applXML, final String curAppName, final String userName, final FlowPanel middleHpnl, FlowPanel middleHpnlOuter)
	{
		try
		{
			HashMap<String, ArrayList<ApplOptions>> applDetMap = parseApplXML(applXML);

			String appName = "";
			String appdecr = "";
			//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
			String applGrp ="";

			if( applDetMap != null )
			{
				int appGrpSize = applDetMap.size();
				int applDetListSize = 0;
				Iterator<String> keySetIt1 = applDetMap.keySet().iterator();
				if( appGrpSize == 1 )
				{
					while( keySetIt1.hasNext() )
					{
						String groupName = keySetIt1.next();
						ArrayList<ApplOptions> applDetList = applDetMap.get(groupName);
						if( applDetList != null )
						{
							applDetListSize = applDetList.size();
						}
					}
				}

				E12CommonUtils.printOnConsole("inside drawMenubar appGrpSize ["+appGrpSize+"] applDetListSize ["+applDetListSize+"]");
				if( appGrpSize == 1 && applDetListSize == 1 )
				{
					E12CommonUtils.printOnConsole("Only one application is available for given user");
				}
				else
				{
					changeElementStyle("topButton-"+E12Constants.userID+"_"+E12Constants.conApplNm);
					changeElementStyle("bottomHpnl-"+E12Constants.userID+"_"+E12Constants.conApplNm);
					if( middleHpnl != null )
					{
						middleHpnl.clear();
					}
					if( middleHpnlOuter != null )
					{
						middleHpnlOuter.setHeight("75%");
					}

					HashMap< String, String > serachFeedMap = new HashMap< String, String >();

					Iterator<String> keySetIt = applDetMap.keySet().iterator();
					String feedDOMId = "";
					int index = 1;
					//Added by Sainath T. on 10-OCT-2019 [To get the group count]
					int applGroupIndex = 1;

					while( keySetIt.hasNext() )
					{
						final String groupName = keySetIt.next();
						ArrayList<ApplOptions> applDetList = applDetMap.get(groupName);
						VerticalPanel appGrpPanel = new VerticalPanel();
						appGrpPanel.setWidth("100%");
						if( applDetList != null )
						{
							HorizontalPanel appGrpDescr = new HorizontalPanel();
							appGrpDescr.addStyleName("appGrpDescription");
							//Added by Sainath T. on 10-OCT-2019 [To implement collapsible list]-Start
							appGrpDescr.addDomHandler(new ClickHandler()
							{
								@Override
								public void onClick(ClickEvent event)
								{
									setCollapsibleListProperty(groupName);
								}

							}, ClickEvent.getType());
							final Image appGrpImage = new Image();
							String url = E12Global.getHostUrl() + "/ibase/images/galaxy/" + groupName + ".png";
							appGrpImage.setUrl(url);

							appGrpImage.addErrorHandler(new ErrorHandler()
							{
								@Override
								public void onError(ErrorEvent event)
								{
									E12CommonUtils.printOnConsole("in image onerror : ");
									appGrpImage.setUrl(E12Global.getHostUrl() + "/ibase/images/galaxy/errMenu.png");
								}
							});
							slidePopupPnl.addStyleName("menuSlidePopupPanelColor");
							//Added by Sainath T. on 10-OCT-2019 [To implement collapsible list]-End
							appGrpImage.addStyleName("appGroupImage");
							Label grpLabel = new Label( groupName );
							grpLabel.addStyleName("appGroupLabel");

							Label blankLabel = new Label("");
							appGrpDescr.add(blankLabel);
							appGrpDescr.add(appGrpImage);
							appGrpDescr.add(grpLabel);
							//Changed and added by Sainath T. on 10-OCT-2019 [To implement collapsible list]-Start
							Label openCloseLabel = new Label("");
							if(applGroupIndex == 1)
							{
								openCloseLabel.setStyleName("vision-ui-arrow_up");
							}
							else
							{
								openCloseLabel.setStyleName("vision-ui-arrow_down");
							}
							openCloseLabel.getElement().setId(groupName+"openCloseLabel");

							openCloseLabel.getElement().setAttribute("style", "height: 100%; padding: 8px 0 0 8px; color: #252525; font-size: 20px;");
							appGrpDescr.addStyleName("appGroupLabel");
							appGrpDescr.add( openCloseLabel );

							appGrpDescr.setCellWidth(blankLabel, "10px");
							//Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
							appGrpDescr.setCellWidth(appGrpImage, "30px");
							appGrpDescr.setCellWidth(grpLabel, "calc(100% - 80px)");
							appGrpDescr.setCellWidth(openCloseLabel, "35px");
							//Changed and added by Sainath T. on 10-OCT-2019 [To implement collapsible list]-End

							appGrpDescr.setCellVerticalAlignment(appGrpImage, HasVerticalAlignment.ALIGN_MIDDLE);
							appGrpDescr.setCellVerticalAlignment(grpLabel, HasVerticalAlignment.ALIGN_MIDDLE);
							appGrpPanel.add(appGrpDescr);
							Iterator<ApplOptions> applDetListIt = applDetList.iterator();
							index = 1;

							while( applDetListIt.hasNext() )
							{
								final ApplOptions applOptions = applDetListIt.next();
								appName = applOptions.getApplName();
								appdecr = applOptions.getApplDescr();
								//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
								applGrp = applOptions.getApplGroup();
								String imgClassName = "";
								if("null".equalsIgnoreCase(appdecr))
								{
									appdecr = appName+"(No description available)";
								}
								//Commented by Sainath T. on 10-OCT-2019 [To set dynamic icos and css]-Start
								/*if( "SFA".equalsIgnoreCase(appName) )
								{
									imgClassName = "SFAIcon";
								}
								else if( "MFG".equalsIgnoreCase(appName) )
								{
									imgClassName = "MFGIcon";
								}
								else if( "SCM".equalsIgnoreCase(appName) )
								{
									imgClassName = "SCMIcon";
								}
								else if( "WMS".equalsIgnoreCase(appName) )
								{
									imgClassName = "WMSIcon";
								}
								else if( "BI".equalsIgnoreCase(appName) )
								{
									imgClassName = "BIIcon";
								}
								else if( "FIN".equalsIgnoreCase(appName) )
								{
									imgClassName = "FINIcon";
								}
								else if( "ADM".equalsIgnoreCase(appName) )
								{
									imgClassName = "ADMIcon";
								}
								else if( "RND".equalsIgnoreCase(appName) )
								{
									imgClassName = "RNDIcon";
								}
								else if( "TRV".equalsIgnoreCase(appName) )
								{
									imgClassName = "TRVIcon";
								}
								// Added by Pankaj R on 03-05-19 to show menu icon[START]
								else if( "PIT".equalsIgnoreCase(appName) )
								{
									imgClassName = "PITIcon";
								}
								else if( "SYS".equalsIgnoreCase(appName) )
								{
									imgClassName = "SYSIcon";
								}
								// Added by Pankaj R on 03-05-19 to show menu icon[END]
								else
								{
									imgClassName = "e12Icon";
								}*/
								//Commented by Sainath T. on 10-OCT-2019 [To set dynamic icos and css]-Start
								feedDOMId = appName+ "" + index;
								//Added by Sainath T. on 10-OCT-2019 [Added groupName, applGroupIndex to apply css classes ]
								//Changed by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
								appGrpPanel.add( addPanel(imgClassName, appdecr, appName, curAppName, userName, middleHpnl, middleHpnlOuter, feedDOMId, groupName, applGroupIndex, applGrp) );
								serachFeedMap.put(feedDOMId, appdecr);
								index++;
							}
							middleHpnl.add(appGrpPanel);
						}
						applGroupIndex++;
					}
					//e12Search.setSearchFeedMap( serachFeedMap );
					isClick = true;
				}

			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside drawMenubar ===> "+e.getMessage());
		}
	}

	private HashMap<String, ArrayList<ApplOptions>> parseApplXML(String applXML)
	{
		HashMap<String, ArrayList<ApplOptions> > applDetMap = new HashMap<String, ArrayList<ApplOptions> >();
		try
		{
			//Window.alert(applXML);
			Document doc = XMLParser.parse(applXML);
			XMLParser.removeWhitespace(doc);
			NodeList applGrpNodeList = doc.getElementsByTagName("APPL_GROUP");
			if( applGrpNodeList!=null )
			{
				int grpLen = applGrpNodeList.getLength();
				for(int i=0; i < grpLen; i++)
				{
					ArrayList<ApplOptions> applDetList = new ArrayList<ApplOptions>();
					Node applGrpNode = applGrpNodeList.item(i);
					NodeList applDetNodeList = applGrpNode.getChildNodes();
					String groupName = applGrpNode.getAttributes().getNamedItem("name").getNodeValue();
					if( applDetNodeList != null )
					{
						int grpChLen = applDetNodeList.getLength();
						for(int j=0; j < grpChLen; j++)
						{
							ApplOptions applOptions = parseApplDetNode( applDetNodeList.item(j) );
							applOptions.setApplGroup( groupName );
							if(applDetMap.get(groupName) != null)
							{
								applDetList = applDetMap.get(groupName);
								applDetList.add(applOptions);
							}
							else
							{
								applDetList.add(applOptions);
							}
						}
					}
					applDetMap.put(groupName, applDetList);
				}
			}


		}
		catch (Exception e)
		{

		}
		return applDetMap;
	}

	private ApplOptions parseApplDetNode(Node applDetNode)
	{
		ApplOptions applOptions = new ApplOptions(" - ");
		NodeList applDetChNodeList = applDetNode.getChildNodes();
		int applDetLen = applDetChNodeList.getLength();
		for(int j = 0; j < applDetLen; j++)
		{
			Node applDetChNode = applDetChNodeList.item(j);
			String nodeName = applDetChNode.getNodeName();
			String nodeValue = E12CommonUtils.checkNull( applDetChNode.getFirstChild().getNodeValue() );
			if( "APP_NAME".equalsIgnoreCase(nodeName) )
			{
				applOptions.setApplName(nodeValue);
			}
			else if( "DESCR".equalsIgnoreCase(nodeName) )
			{
				applOptions.setApplDescr(nodeValue);
				if( "".equalsIgnoreCase(nodeValue) )
				{
					applOptions.setDelimiter("");
				}
			}
			else if( "APPL_COLOR".equalsIgnoreCase(nodeName) )
			{
				applOptions.setApplColor(nodeValue);
			}
		}
		return applOptions;
	}

	class ApplOptions
	{
		private String applGroup;
		private String applName;
		private String applColor;
		private String applDescr;
		private String delimiter = "";

		public ApplOptions()
		{
			this.delimiter = "";
		}
		public ApplOptions( String delimiter )
		{
			this.delimiter = delimiter;
		}
		public String getApplGroup()
		{
			return applGroup;
		}
		public void setApplGroup(String applGroup)
		{
			this.applGroup = applGroup;
		}
		public String getApplName()
		{
			return applName;
		}
		public void setApplName(String applName)
		{
			this.applName = applName;
		}
		public String getApplColor()
		{
			return applColor;
		}
		public void setApplColor(String applColor)
		{
			this.applColor = applColor;
		}
		public String getApplDescr()
		{
			if( "".equalsIgnoreCase(applDescr) )
			{
				return applGroup;
			}
			return applDescr;
		}
		public void setDelimiter(String delimiter)
		{
			this.delimiter = delimiter;
		}
		public void setApplDescr(String applDescr)
		{
			this.applDescr = applDescr;
		}

		public String getApplGroupDescr()
		{
			return applGroup + delimiter + applDescr;
		}
	}

	private PanelLabel getPanelLabel( FlowPanel middleHpnl, String id )
	{
		PanelLabel panelLabel = null;
		try
		{
			if( middleHpnl != null )
			{
				int count = middleHpnl.getWidgetCount();
				if( count > 0 )
				{
					for( int i = 0; i < count; i++ )
					{
						if( middleHpnl.getWidget(i) instanceof VerticalPanel )
						{
							VerticalPanel vp = (VerticalPanel) middleHpnl.getWidget(i);
							int innerWidget = vp.getWidgetCount();
							if( innerWidget > 0 )
							{
								for( int j = 0; j < innerWidget; j++ )
								{
									if( vp.getWidget(j) instanceof PanelLabel )
									{
										PanelLabel selectedApplication = (PanelLabel) vp.getWidget(j);
										String panelId = E12CommonUtils.checkNull( selectedApplication.getElement().getId() );
										if( !"".equalsIgnoreCase(panelId) && id.equalsIgnoreCase(panelId) )
										{
											panelLabel = selectedApplication;
											return selectedApplication;
										}
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside getPanelLabel ==> "+e.getMessage());
		}
		return panelLabel;
	}

	public void getApplicationsInfo( final FlowPanel middleHpnl, final FlowPanel middleHpnlOuter )
	{
		try
		{
			String curAppl = E12Constants.conApplNm;
			String curUserId = E12Constants.userID;
			final String curAppName = curAppl;
			final String userName = curUserId;
			E12CommonUtils.printOnConsole("inside slideMenuImage curUserId "+curUserId);
			E12CommonUtils.printOnConsole("inside slideMenuImage curAppl "+curAppl);
			String key = curUserId + "/Applicaton_List";
			E12Storage.getItem(key, new Callback<String, String>() {

				@Override
				public void onSuccess(String result)
				{
					String applicationListResp = E12CommonUtils.checkNull(result);
					if( applicationListResp.length() > 0 )
					{
						E12CommonUtils.printOnConsole("inside slideMenuImage applicationListResp ["+applicationListResp+"]");
						drawMenubar(applicationListResp, curAppName, userName, middleHpnl, middleHpnlOuter);
					}
					//Added by sunny soni for not getting data from storage[Start]
					else
					{
						if(!E12Global.getInstance().isOffline())
						{
							String path = E12Global.getHostUrl() + "/ibase/WEBITMRIARequestHandlerServlet?ACTION=GET_APPL_MST_INFO";
							//Added by sunny soni for getting login details map[start]
							String paramString = E12CommonUtils.getInstance().getEncodedParamString(E12CommonUtils.getLoginDetailsMap());
							//Added by sunny soni for getting login details map[end]
							//E12RequestBuilder requestBuilder = new E12RequestBuilder(RequestBuilder.POST, path);
							E12RequestBuilder requestBuilder = new E12RequestBuilder(RequestBuilder.POST, path+"&"+paramString);
							try
							{
								//RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, path);
								//rb.sendRequest(null, new RequestCallback()
								requestBuilder.sendRequest( "", new RequestCallback()
								{
									@Override
									public void onResponseReceived(Request request, Response response)
									{
										String applNms = response.getText();

										if(applNms!=null )
										{
											String key = userName + "/Applicaton_List";
											E12Storage.setItem(key, applNms);
											drawMenubar(applNms, curAppName, userName, middleHpnl, middleHpnlOuter);
										}
									}

									@Override
									public void onError(Request request, Throwable exception)
									{

									}
								});
							}
							catch (Exception e)
							{
								e.printStackTrace();
							}
						}
					}
					//Added by sunny soni for not getting data from storage[End]
				}

				@Override
				public void onFailure(String reason) {

				}
			});
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside getApplicationsInfo ===> "+e.getMessage());
		}
	}

	protected void setNewApplicationInfo( String appName, final Callback<Boolean, Boolean> callBack )
	{
		try
		{
			appName = appName.substring(0, (appName.length() - 1));
			E12Constants.conApplNm = appName;
			this.meLogin = E12Global.getInstance().getMeLogIn();
			String displayMessage = "Would you like this to be default application?";
			MELogin.isAppChange = true;
			MELogin.isNew = true;
			//Added by sadique shaikh 30-10-2019 [Change confirm popup to custom confirm]	
			E12AlertBox.getInstance().confirm(displayMessage, "Confirm", new CallbackHandler() {
				
				@Override
				public void onCallback(boolean result) 
				{
					E12CommonUtils.printOnConsole(" onCallback confirm = "+result);
					if(result)
					{
						if( meLogin != null )
						{
							MELogin.defaultApp = true;
							deleteApplications( new Callback<Boolean, Boolean>() {

								@Override
								public void onFailure(Boolean reason) {

								}

								@Override
								public void onSuccess(Boolean result)
								{
									if( result )
									{
										callBack.onSuccess(true);
									}
									else
									{
										callBack.onSuccess(false);
									}
								}
							});
						}
					}
					else
					{
						MELogin.defaultApp = false;
						meLogin.processUserData();
						callBack.onSuccess(true);
					}

				}
			});
			//Commented by sadique shaikh 30-10-2019 [Change confirm popup to custom confirm]	
			/*if( Window.confirm(displayMessage) )
			{
				if( meLogin != null )
				{
					MELogin.defaultApp = true;
					deleteApplications( new Callback<Boolean, Boolean>() {

						@Override
						public void onFailure(Boolean reason) {

						}

						@Override
						public void onSuccess(Boolean result)
						{
							if( result )
							{
								callBack.onSuccess(true);
							}
							else
							{
								callBack.onSuccess(false);
							}
						}
					});
				}
			}
			else
			{
				MELogin.defaultApp = false;
				meLogin.processUserData();
				callBack.onSuccess(true);
			}
			*/
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside setNewApplicationInfo ===> "+e.getMessage());
			callBack.onSuccess(false);
		}
	}

	protected void deleteApplications(final Callback<Boolean, Boolean> callBack)
	{
		try
		{
			MELogin.isDeleted = true;
			if( Storage.isSupported() )
			{
				E12Storage.getItem("curConnection", new Callback<String, String>() {

					@Override
					public void onFailure(String reason) {
						callBack.onSuccess(false);
					}

					@Override
					public void onSuccess(String result) {
						conIdToDelete = E12CommonUtils.checkNull(result);
						conIdToDelete = conIdToDelete.substring(1, conIdToDelete.length() - 2);
						E12CommonUtils.printOnConsole("conIdToDelete ["+conIdToDelete+"]");
						E12Storage.getItem(conIdToDelete, new Callback<String, String>() {
							@Override
							public void onSuccess(String result) {
								String itemValue = E12CommonUtils.checkNull( result );
								final Map<String, String> curMap = E12ApplicationsPanel.retrieveMap( itemValue );
								try
								{
									String key = curMap.get( "curUser") +"-"+curMap.get("selectedAppName");
									E12SlideMenuPanel.getInstance( key ).slidePopupPnl.hide();
									E12CommonUtils.printOnConsole("ROMOVE APP IS 1242: "+curMap.get("selectedAppName"));
									E12SlideMenuPanel.getInstance( key ).menuPanelMap.remove( key );
									E12CommonUtils.printOnConsole("ROMOVE APP IS 1243: "+curMap.get("curUser"));

								}
								catch (Exception e)
								{
									E12CommonUtils.printOnConsole("Exception DeleteConnection ["+e.getMessage()+"]");
								}
								ArrayList<String> userIdList = E12Global.getInstance().getExistConnectionMap().get( "userId" );
								ArrayList<String> appNmList = E12Global.getInstance().getExistConnectionMap().get( "selectedAppName" );
								ArrayList<String> serverIPList = E12Global.getInstance().getExistConnectionMap().get( "serverIP" );
								E12CommonUtils.printOnConsole("at line 1982.1 == "+userIdList);
								if( userIdList != null && userIdList.size() > 0 )
								{
									userIdList.remove( curMap.get( "curUser" ) );
								}
								if( appNmList != null && appNmList.size() > 0 )
								{
									appNmList.remove( curMap.get("selectedAppName") );
								}
								if( serverIPList != null && serverIPList.size() > 0 )
								{
									serverIPList.remove( curMap.get( "curServerIP" ) );
								}
                                E12CommonUtils.printOnConsole("at line 1982");
                                // Added by Mahesh Saggam [29-APR-21] [slow loading on switch application] Start
                                if((E12Global.getInstance().getDeviceOS() == DeviceOS.Android || E12Global.getInstance().getDeviceOS() == DeviceOS.iOS) && !E12Global.getInstance().isHostedMode())
                                {
                                    E12CommonUtils.printOnConsole("Print line 2464 :::::: conIdToDelete ["+conIdToDelete+"]");
                                    E12Storage.removeItem(conIdToDelete);
                                    // Added by Mahesh Saggam [29-APR-21] [slow loading on switch application] End
                                }
								else if((E12Global.getInstance().getDeviceOS() == DeviceOS.Android || E12Global.getInstance().getDeviceOS() == DeviceOS.iOS)
										&& "Yes".equalsIgnoreCase(E12Global.getInstance().getPreference().get("isIDBSupported"))
										&& "Yes".equalsIgnoreCase(E12Global.getInstance().getPreference().get("isTableCreated")) )
								{
									E12CommonUtils.printOnConsole("at line 1988");
									E12Storage.getKeys( new Callback<String, String>()
									{
										@Override
										public void onSuccess(String result)
										{
											String keys = E12CommonUtils.checkNull(result);
											E12CommonUtils.printOnConsole("at line 1994 keys ==> "+keys);
											if( keys.length() > 0 )
											{
												String[] keysArr = keys.split( "~~~" );
												for (int i = 0; i < keysArr.length; i++)
												{
													String key = E12CommonUtils.checkNull( keysArr[i] );
													E12CommonUtils.printOnConsole("at line 2001 key ["+key+"]");
													if(key!=null && key.contains(conIdToDelete)){
														E12Storage.removeItem( key );
													}
												}
											}
										}
										@Override
										public void onFailure(String reason) {
										}
									});
								}
								else
								{
									final int storageLength = E12Storage.getLength();
									for (int i = 0; i < storageLength; i++)
									{
										String key = E12CommonUtils.checkNull( E12Storage.key(i) );
										if(key!=null && key.contains(conIdToDelete)){
											E12CommonUtils.printOnConsole("at line 2019 key ["+key+"]");
											E12Storage.removeItem( key );
										}
									}
								}
								if((E12Global.getInstance().getDeviceOS() == DeviceOS.Android || E12Global.getInstance().getDeviceOS() == DeviceOS.iOS)
										&& "Yes".equalsIgnoreCase(E12Global.getInstance().getPreference().get("isIDBSupported"))
										&& "Yes".equalsIgnoreCase(E12Global.getInstance().getPreference().get("isTableCreated")) )
								{
									E12Storage.deleteTable(curMap.get( "curUser" ));
								}
								meLogin.processUserData();
								callBack.onSuccess(true);
							}

							@Override
							public void onFailure(String reason) {
								Window.alert( "Exception getting item value from websql when click on delete button. ["+reason+"]" );
								callBack.onSuccess(false);
							}

						});
					}
				});
			}
			else
			{
				callBack.onSuccess(false);
			}
		} catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception inside deleteApplications ===> "+e.getMessage());
			callBack.onSuccess(false);
		}
	}

	public native void changeElementStyle(String className)
	/*-{
		try
		{
			var id = className;
			var x = $doc.getElementById(id);
			if(x != null )
			{
				x.style.display = 'none';
			}
		}
		catch( e )
		{
			console.log( "setElementStyle - ["+ e +"]" );
		}
	 }-*/;
	//Added by Sandeep S. on 24-OCT-17 [User can change application by tapping app icon inside menu/left panel] end
	//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]Start
	private void setEnterpriseLogo(final CachedImage img)
	{
		E12CommonUtils.printOnConsole("Inside setEnterpriseLogo() : "+E12Constants.enterprise);

		final String enterprise = E12CommonUtils.checkNull(E12Constants.enterprise);
		E12CommonUtils.printOnConsole("E12Global.getHostUrl()["+E12Global.getHostUrl()+"]");
		E12CommonUtils.printOnConsole("E12Constants.hostUrl["+E12Constants.hostUrl+"]");
		E12CommonUtils.printOnConsole("MELogin.hostUrl["+MELogin.hostUrl+"]");

		if( enterprise.length() > 0 )
		{
			img.setUrl(E12Global.getHostUrl()+"/ibase/images/"+enterprise+".png");
			img.addStyleName("enterpriseLogo");
			img.addErrorHandler(new ErrorHandler()
			{
				@Override
				public void onError(ErrorEvent event)
				{
					E12CommonUtils.printOnConsole("in image onerror : ");
					img.setImmediateUrl(E12Global.getHostUrl()+"/ibase/images/clientSlideLogo.png");
				}
			});
		}
		else
		{
			img.setUrl(E12Global.getHostUrl()+"/ibase/images/clientSlideLogo.png");
		}
	}
	//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]End

	public void drawNoofSites(final String xmlData, final FlowPanel middleHpnl, final FlowPanel middleHpnlOuter, final String selectedApplication)
	{
		try
		{
			Document document = XMLParser.parse( xmlData );
			XMLParser.removeWhitespace(document);
			if( document != null && document.hasChildNodes() )
			{
				//Commented by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ]
				//PanelLabel selectedApp = getPanelLabel(middleHpnl, selectedApplication);
				//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ] Start
				E12CommonUtils.printOnConsole("E12Constants.applicationGroup  drawNoofSites"+E12Constants.applicationGroup );
				SimplePanel menuPanel = new SimplePanel();
				SimplePanel imagePanel = new SimplePanel();
				final Image appGrpImage = new Image();
				String url = E12Global.getHostUrl() + "/ibase/images/galaxy/" + E12Constants.applicationGroup + ".png";
				appGrpImage.setUrl(url);

				//Added By Sainath T. on 15-OCT-2019 [to set error img] - Start
				appGrpImage.addErrorHandler(new ErrorHandler()
				{
					@Override
					public void onError(ErrorEvent event)
					{
						E12CommonUtils.printOnConsole("in image onerror : ");
						appGrpImage.setUrl(E12Global.getHostUrl() + "/ibase/images/galaxy/errMenu.png");
					}
				});
				//Added By Sainath T. on 15-OCT-2019 [to set error img] - End

				appGrpImage.addStyleName("menuImg favaAndOptionMenuImage");
				appGrpImage.getElement().setAttribute("style", "height: 21px !important;width: 21px !important;background-color: #efefef;");
				imagePanel.add(appGrpImage);
				imagePanel.addStyleName("favaAndOptionMenuImg");

				HTMLPanel htmlPanel = new HTMLPanel( "<div class='favaAndOptionPanelSpan E12favourite-list' style='max-height: 40px !important;'><div style='font-size: 14px;font-weight: 700;'>"+ E12Constants.applicationGroup +"</div>"
						+ "<div style='font-size: 12px;color: #666;'>"+E12Constants.applDescr +"</div></div>" );
				htmlPanel.getElement().setId("pathHtmlPanel");
				htmlPanel.addStyleName("favaAndOptionSecondDiv");
				htmlPanel.getElement().setAttribute("style", "width: calc(100% - 54px);");
				FlowPanel flowPanel = new FlowPanel();

				HTML favIconTextHtml3 = new HTML( "<div class='vision-ui-switch switchIcon' style='background-color: var(--primary);margin-right: 7px;'> </div>" );
				favIconTextHtml3.addClickHandler(new ClickHandler() {

					@Override
					public void onClick(ClickEvent event)
					{
						E12CommonUtils.printOnConsole("inside appSwitch");
						getApplicationsInfo(middleHpnl, middleHpnlOuter);
					}
				});
				//HorizontalPanel hortPanel = new HorizontalPanel();
				middleHpnl.clear();
				E12Search e12Search = new E12Search();
				e12Search.setStyleName("applicationSearchBar");
				SimplePanel innerDiv = new SimplePanel();
				innerDiv = (SimplePanel) e12Search.searchTextBox.getParent();
				if( innerDiv != null )
				{
					innerDiv.setStyleName("applicationsearchboxform");
					e12Search.searchTextBox.setStyleName("applicationsearchtextbox");
					e12Search.searchTextBox.getElement().setPropertyString( "placeholder" , "Search login site" );
				}

				/*if( selectedApp != null )
				{
					selectedApp.setCommand(null);
					//middleHpnl.add( selectedApp );
					hortPanel.add( selectedApp );
					selectedApp.getElement().getStyle().setBorderStyle(BorderStyle.NONE);
					selectedApp.getElement().getStyle().setOverflow(Overflow.HIDDEN);
					hortPanel.add( favIconTextHtml3 );
					favIconTextHtml3.getElement().getStyle().setMarginTop(8, Unit.PX);
					//hortPanel.setWidth("100%");
					hortPanel.setCellWidth(favIconTextHtml3, "15%");
					hortPanel.addStyleName("appHorizonntab");
					middleHpnl.add( hortPanel );
				}*/
				flowPanel.addStyleName("favaAndOptionFlowPnl");
				flowPanel.getElement().setAttribute("style", "width: calc(100% - 16px);background-color: #efefef;");

				flowPanel.add(imagePanel);
				flowPanel.add( htmlPanel );
				flowPanel.add( favIconTextHtml3 );

				menuPanel.add(flowPanel);
				middleHpnl.add( menuPanel );
				//Added by Pooja S on 11-oct-2019 [To Module name should be display in grey with application change icon ] End
				middleHpnl.add( e12Search );

				NodeList siteCodesNL = document.getElementsByTagName( "SITES" ).item(0).getChildNodes();
				int lenght = siteCodesNL.getLength();
				if( lenght == 1 )
				{
					Node siteNode = siteCodesNL.item(0);
					String siteCode = siteNode.getAttributes().getNamedItem( "code" ).getNodeValue();
					String siteType = siteNode.getAttributes().getNamedItem( "siteType" ).getNodeValue();
					String profileId = siteNode.getAttributes().getNamedItem( "profileId" ).getNodeValue();
					String city = siteNode.getAttributes().getNamedItem( "city" ).getNodeValue();
					//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
					String enterprise = siteNode.getAttributes().getNamedItem( "ENTERPRISE" ).getNodeValue();
					String siteDescr = siteNode.getFirstChild().getNodeValue();
					//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-Start
					String fin_entity = siteNode.getAttributes().getNamedItem( "FIN_ENTITY" ).getNodeValue();
					String facility_code = siteNode.getAttributes().getNamedItem( "FACILITY_CODE" ).getNodeValue();
					//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-End
					String feedDOMId = "feed0";
					E12Constants.siteCode = siteCode;
					E12Constants.siteDescr = siteDescr;
					//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
					//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-Start
					//WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise);
					final WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, "", city, enterprise,fin_entity,facility_code);
					//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-End

					setNewApplicationInfo(selectedApplication, new Callback<Boolean, Boolean>() {

						@Override
						public void onFailure(Boolean reason) {
							isClick = false;

						}

						@Override
						public void onSuccess(Boolean result)
						{
							isClick = false;
							if( result )
							{
								closeSlidePopup();
								hidePnl();
								String key = E12Constants.userID +"-"+E12Constants.conApplNm;
								if( E12CommonUtils.getInstance().getSlidePopupPnl(key) != null )
								{
									E12CommonUtils.getInstance().getSlidePopupPnl(key).hide();
								}
								Timer t = new Timer() {

									@Override
									public void run() {
										E12CommonUtils.printOnConsole("E12SlideMenu : 530 finally closed");
										slidePopupPnl = null;
										meLogin.setSelectedSiteInfo( wrapSiteInfo );
									}
								};
								t.schedule(120);
							}

						}
					});
				}
				else if( lenght >= 2 )
				{
					HashMap< String, String > serachFeedMap = new HashMap< String, String >();
					for( int index = 0; index < lenght; index++ )
					{
						Node siteNode = siteCodesNL.item(index);
						String siteCode = siteNode.getAttributes().getNamedItem( "code" ).getNodeValue();
						String siteType = siteNode.getAttributes().getNamedItem( "siteType" ).getNodeValue();
						String profileId = siteNode.getAttributes().getNamedItem( "profileId" ).getNodeValue();
						String city = siteNode.getAttributes().getNamedItem( "city" ).getNodeValue();
						//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
						String enterprise = siteNode.getAttributes().getNamedItem( "ENTERPRISE" ).getNodeValue();
						String siteDescr = siteNode.getFirstChild().getNodeValue();
						//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-Start
						String fin_entity = siteNode.getAttributes().getNamedItem( "FIN_ENTITY" ).getNodeValue();
						String facility_code = siteNode.getAttributes().getNamedItem( "FACILITY_CODE" ).getNodeValue();
						//Added by Pratheek on 04-02-19[storing the fin_entity and facility_code value of different site for reports]-End
						String feedDOMId = "feed"+index;
						E12Constants.siteCode = siteCode;
						E12Constants.siteDescr = siteDescr;
						String imgClassName = "";
						if( "F".equalsIgnoreCase(siteType) )
						{
							imgClassName = "factoryIcon";
						}
						else if( "W".equalsIgnoreCase(siteType) )
						{
							imgClassName = "warehouseIcon";
						}
						else
						{
							imgClassName = "officeIcon";
						}
						serachFeedMap.put(feedDOMId, siteDescr);
						//added by vishal pathare on 13.4.18 for[site wise enterprise image related changes]
						//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-Start
						//WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise);
						WrapSiteInfo wrapSiteInfo = new WrapSiteInfo(siteCode, siteType, siteDescr, profileId, feedDOMId, imgClassName, city, enterprise,fin_entity,facility_code);
						//Added by Pratheek on 04-02-19[passing the updated fin_entity and facility_code value when selecting different site]-End
						middleHpnl.add( addFeedPanel(wrapSiteInfo, selectedApplication) );
					}
					e12Search.setSearchFeedMap( serachFeedMap );
				}
				else
				{
					Window.alert( E12Constants.constants.setMsgNoSite() );
					isClick = false;
				}
				Window.scrollTo(0, 0);
				middleHpnl.getElement().setScrollTop(0);
			}
		}
		catch (Exception e) {
			// TODO: handle exception
		}
	}

	//Changed by Prasad on 14/09/19 [menn panel related ui changes] START
	private FlowPanel socialPanel = new FlowPanel();
	public void getSocialPanel()
	{
		try
		{
			E12SocialModel e12SocialModel = new E12SocialModel();
			E12CommonUtils.printOnConsole("refresh return flowPanel");
			if( socialPanel.getWidgetCount() == 0 )
			{
				for ( Iterator i = e12SocialModel.getE12Social().iterator(); i.hasNext() ; )
				{
					E12SocialModel.E12Feed feed = ( E12SocialModel.E12Feed ) i.next();
					E12CommonUtils.printOnConsole("refresh feed "+feed);
					socialPanel.add(getPanel( feed.getTitle(), feed.getComment(), feed.getIcon() ));
					//add(contentPanel);
				}
				if( e12SocialModel.getE12Social().size() == 1 )
				{
					E12SocialModel.E12Feed feed = ( E12SocialModel.E12Feed )e12SocialModel.getE12Social().get(0);
					optionSelected(feed.getTitle());
				}
			}
		}
		catch (Exception e) {
			Window.alert("Exception : E12SocialPanel:refresh() ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		//E12CommonUtils.printOnConsole("refresh contentPanel"+socialPanel);
		menuContentPanel.add( socialPanel );
	}

	public PanelLabel getPanel( final String title, String comment, String icon )
	{
		PanelLabel panelLabel = null;
		try
		{
			HorizontalPanel completeHoriPanel = new HorizontalPanel();
			E12CommonUtils.printOnConsole("refresh return getPanel getPanel sds5d4sa 0 "+title );
			HTML favIconTextHtml1 = new HTML( "<HTML><TABLE><TR><TD class='"+icon+"'> </TD></TR></TABLE></HTML>" );
			HTML favIconTextHtml2 = new HTML( "<HTML><TABLE><TR><TD VALIGN='bottom' ><span class='E12favourite-list'>" + title + "</span></TD> </TR> <TR> <TD VALIGN='top'><span class='E12favourite-list'>" + /*entry.getComment() +*/"</span></TD> </TR></TABLE></HTML>" );
			completeHoriPanel.add( favIconTextHtml1 );
			completeHoriPanel.add( favIconTextHtml2 );

			panelLabel = new PanelLabel( completeHoriPanel, new Command() {

				public void execute()
				{
					E12CommonUtils.printOnConsole("refresh title "+title);
					slidePopupPnl.hide();
					optionSelected(title);
				}
			}) {
			};
			panelLabel.setText( title );

		}
		catch (Exception e) {
			Window.alert("Exception : E12SocialPanel:getPanel() :"+e.getMessage());
			e.printStackTrace();
		}
		return panelLabel;
	}

	public void optionSelected( String title )
	{
		E12Constants.feedPanelId = "";
		E12CommonUtils.printOnConsole("optionSelected optionSelected"+title);
		try
		{
			E12SocialPanel e12SocialPanel = null;
			e12SocialPanel = ( E12SocialPanel )  E12Global.getInstance().getPanel("M_Social");
			if( e12SocialPanel == null )
			{
				e12SocialPanel = new E12SocialPanel( E12Constants.constants.setBulletinBoardLbl(), e12SocialPanel, title );
			}
			else
			{
				e12SocialPanel.enter(title);
			}
		}
		catch (Exception e)
		{
			Window.alert("Excepetion : E12SocialPanel: enter() "+e.getMessage());
			e.printStackTrace();
		}
	}

	private native String getSelectedMenuOption()
	/*-{
		var menuOptions = $doc.getElementsByClassName( 'menuOption' );
		console.log( 'menuOptions.length ', menuOptions.length );
		var optTitle = "";
		for ( var optionCtr = 0; optionCtr < menuOptions.length; optionCtr++ )
		{
			optTitle = menuOptions[ optionCtr ].title;
			console.log( 'optTitle ', optTitle );
			var optClassName = menuOptions[ optionCtr ].className;
			console.log( 'optClassName ', optClassName );
			if ( optClassName.indexOf( "selectedMenu" ) != -1 )
			{
				console.log( 'inside indexof' );
				break;
			}
		}
		return optTitle;
	}-*/;

	private native void setMenuOptionSelected( String optionTitle )
	/*-{
		var menuOptions = $doc.getElementsByClassName( 'menuOption' );
		console.log( 'menuOptions.length ', menuOptions.length );
		for ( var optionCtr = 0; optionCtr < menuOptions.length; optionCtr++ )
		{
			var optTitle = menuOptions[ optionCtr ].title;
			console.log( 'optTitle ', optTitle );
			var optClassName = menuOptions[ optionCtr ].className;
			console.log( 'optClassName ', optClassName );
			if ( optTitle === optionTitle )
			{
				if ( optClassName.indexOf( "selectedMenu" ) == -1 )
				{
					menuOptions[ optionCtr ].className += " selectedMenu";
				}
			}
			else
			{
				console.log( 'indexof', optClassName.indexOf( "selectedMenu" ) );
				if ( optClassName.indexOf( "selectedMenu" ) != -1 )
				{
					console.log( 'inside indexof' );
					menuOptions[ optionCtr ].className = optClassName.replace( " selectedMenu", "" );
				}
			}
		}
	}-*/;

	private String getDeviceType()
	{
		String deviceType = "Other";
		if ( Window.Navigator.getPlatform().indexOf( "iPhone" ) != -1 )
		{
			deviceType= "iPhone";
		}
		else if ( Window.Navigator.getPlatform().indexOf( "iPad" ) != -1 )
		{
			deviceType = "iPad";
		}
		else if ( Window.Navigator.getUserAgent().indexOf("Android") != -1 )
		{
			if( Window.Navigator.getUserAgent().indexOf("Mobile") != -1)
			{
				deviceType = "Mobile";
			}
			else
			{
				deviceType = "Tablet";
			}
		}
		return deviceType;
	}

	private FlowPanel getClientDetailPanel( String result )
	{
		FlowPanel topTitlenLogo = new FlowPanel();
		topTitlenLogo.getElement().setId("topTitlenLogo");

		final FlowPanel topIcon = new FlowPanel();
		topIcon.getElement().setId("topIcon");
		topIcon.setStyleName("topIconPnl");

		//Changed by Sagar B. for offline related changes[09-Feb-19]
		final CachedImage img = new CachedImage();
		setEnterpriseLogo(img);
		img.setStyleName("logInScreen");
		topIcon.add(img);

		final FlowPanel topTitle = new FlowPanel();
		topTitle.getElement().setId("topTitle");
		topTitle.setStyleName("topTitlePnl");

		String currConnectionInfo = result;
		String descriptionLabel = E12Constants.descriptionDetails;
		String clientTitle = "";
		String clientDesc = "";
		String curAppDesc = "";
		String fromStorage = E12Storage.getItemLocalStorage("DESCDETAILS");
		E12CommonUtils.printOnConsole("593 ******* descriptionLabel ["+fromStorage+"] from Constants ["+E12Constants.descriptionDetails+"] and userCode ["+E12Constants.userID+"]");
		try
		{
			if(currConnectionInfo != null)
			{
				String connectionInfo[] =  currConnectionInfo.split(",");
				for( int i = 0; i < connectionInfo.length; i++ )
				{
					String s = E12CommonUtils.checkNull(connectionInfo[i]);
					if( s.contains("curAppDesc") )
					{
						curAppDesc = s;
						break;
					}
				}
				if( !"".equalsIgnoreCase(curAppDesc) && curAppDesc.indexOf("=") != -1 )
				{
					curAppDesc = curAppDesc.substring(curAppDesc.indexOf("=") + 1, curAppDesc.length());
					E12Constants.currAppName = curAppDesc;
				}
			}
		}
		catch (Exception e1)
		{
			curAppDesc = E12Constants.currAppName;
			E12CommonUtils.printOnConsole("Exception in E12SlideMenuPanel.createSlideMenuPanel() for currApp : "+e1);
		}
		E12CommonUtils.printOnConsole("curAppDesc E12Constant ::: "+E12Constants.currAppName);
		//Added by Pankaj R on 21-Dec-2017 [end]
		try
		{
			//Changed by nikita on 3-05-17 for logo start
			if( !"".equalsIgnoreCase( E12Constants.descriptionDetails ) )
			{
				String [] descArray = descriptionLabel.split(",");
				descriptionLabel = descArray[1];
				//clientTitle = descriptionLabel.substring(0, descriptionLabel.indexOf("("));
				//clientDesc = descriptionLabel.substring( descriptionLabel.indexOf("(") -1, descriptionLabel.indexOf(")")+1);

				if( descriptionLabel.contains("("))
				{
					clientTitle = descriptionLabel.substring(0, descriptionLabel.indexOf("("));
					clientDesc = descriptionLabel.substring( descriptionLabel.indexOf("(") -1, descriptionLabel.indexOf(")")+1);
				}
				else if( descriptionLabel.contains("[") )
				{
					clientTitle = descriptionLabel.substring(0, descriptionLabel.indexOf("["));
					clientDesc = descriptionLabel.substring( descriptionLabel.indexOf("[") -1, descriptionLabel.indexOf("]")+1);
				}
				else
				{
					clientTitle = descriptionLabel;
					clientDesc = "";
				}
			}
			else
			{
				if( !"".equalsIgnoreCase( fromStorage ) )
				{
					String [] descArray = fromStorage.split(",");
					fromStorage = descArray[1];

					if( fromStorage.contains("("))
					{
						clientTitle = fromStorage.substring(0, fromStorage.indexOf("("));
						clientDesc = fromStorage.substring( fromStorage.indexOf("(") -1, fromStorage.indexOf(")")+1);
					}
					else if( fromStorage.contains("[") )
					{
						clientTitle = fromStorage.substring(0, fromStorage.indexOf("["));
						clientDesc = fromStorage.substring( fromStorage.indexOf("[") -1, fromStorage.indexOf("]")+1);
					}
					else
					{
						clientTitle = fromStorage;
						clientDesc = "";
					}
					//Changed by nikita on 3-05-17 for logo end
				}
			}
		}
		catch (Exception e)
		{
			E12CommonUtils.printOnConsole("Exception slidePnl : ["+e.getMessage()+"]");
			//clientTitle = "SFA";
			//clientDesc = "(Sales Force Automation)";
		}

		String htmlString = "";
		String htmlString1 = "";
		String deviceType = getDeviceType();

		if( E12Global.getInstance().getDeviceOS() == DeviceOS.iOS && "iPad".equalsIgnoreCase(deviceType) )
		{
			//Added by Bhupendra M for Ui realted changes in App on 11-10-17 Start
			/*htmlString = "<div style='font-size: 20px; Color: white;'>"+clientTitle+"</div>";
			htmlString1 = "<div style='font-size: 13px; Color: white;'>"+clientDesc+"</div>";*/
			//Added by saiprasad G. for getting the full clientTitle [START]
			htmlString = "<div class='clientTittle'>"+clientTitle+"</div>";
			//Added by saiprasad G. for getting the full clientTitle [END]
			//htmlString = "<div style='font-size: 20px; Color: white; font-weight: 700;'>"+clientTitle+"</div>";
			//htmlString1 = "<div style='font-size: 13px; Color: white; font-weight: 700;'>"+clientDesc+"</div>";
			//Added by Pankaj R on 21-Dec-2017 to set Current App Name[Start]
			htmlString1 = "<div class='curAppDesc' style='color: white;'>"+E12Constants.currAppName+"</div>";
			//Added by Pankaj R on 21-Dec-2017 to set Current App Name[End]
			//Added by Bhupendra M for Ui realted changes in App on 11-10-17 End
		}
		else
		{
			//Added by Bhupendra M for Ui realted changes in App on 11-10-17 Start
			/*htmlString = "<div style='font-size: 18px; Color: white;'>"+clientTitle+"</div>";
			htmlString1 = "<div style='font-size: 11px; Color: white;'>"+clientDesc+"</div>";*/

			//htmlString = "<div style='font-size: 18px; Color: white; font-weight: 700;'>"+clientTitle+"</div>";
			//Added by saiprasad G. for getting the full clientTitle [START]
			/*htmlString = "<div style='font-size: 16px;Color: white;font-weight: 600;white-space: normal"
					+ ";display: -webkit-box;max-height: 64px;line-height: 1;-webkit-line-clamp: 4;"
					+ "-webkit-box-orient: vertical;overflow: hidden;text-overflow: ellipsis'>"+clientTitle+"</div>";*/
			htmlString = "<div class ='clientTittle'>"+clientTitle+"</div>";

			//Added by saiprasad G. for getting the full clientTitle [END]
			//htmlString1 = "<div style='font-size: 11px; Color: white; font-weight: 700;'>"+clientDesc+"</div>";
			//Added by Pankaj R on 21-Dec-2017 to set Current App Name[Start]
			htmlString1 = "<div class='curAppDesc' style='color: white;'>"+E12Constants.currAppName+"</div>";
			//Added by Pankaj R on 21-Dec-2017 to set Current App Name[End]

			//Added by Bhupendra M for Ui realted changes in App on 11-10-17 End
		}

		//String htmlString = "<div style='font-size: 18px; Color: white;'>"+clientTitle+"</div>";
		//String htmlString1 = "<div style='font-size: 11px; Color: white;'>"+clientDesc+"</div>";
		HTMLPanel htmlPanel = new HTMLPanel(htmlString);
		HTMLPanel htmlPanel1 = new HTMLPanel(htmlString1);
		topTitle.add(htmlPanel);
		topTitle.add(htmlPanel1);

		//Added by saiprasad G. for not getting the current application description[START]
		htmlPanel1.getElement().setAttribute("style", "display: none;");
		//Added by saiprasad G. for not getting the current application description[END]

		//Pooja
		topTitlenLogo.setStyleName("topTitlenLogo");
		topTitlenLogo.add(topIcon);
		topTitlenLogo.add(topTitle);

		return topTitlenLogo;
	}
	//Changed by Prasad on 14/09/19 [menn panel related ui changes] END
	//Added by Sainath T. on 10-OCT-2019 [To change the properties of application list-collapsible list] -Start
	private native void setCollapsibleListProperty(final String groupName)
	/*-{
		var menuList = $doc.getElementsByClassName( groupName+'_appl_grp' );
		console.log( 'menuList.length ', menuList.length );
		var openCloseEle = $doc.getElementById( groupName+'openCloseLabel');

		if(!openCloseEle.classList.contains('vision-ui-arrow_down'))
		{
			openCloseEle.classList.add('vision-ui-arrow_down');
			openCloseEle.classList.remove('vision-ui-arrow_up');
		}
		else
		{
			openCloseEle.classList.add('vision-ui-arrow_up');
			openCloseEle.classList.remove('vision-ui-arrow_down');
		}
		for(var i = 0; i < menuList.length; i++)
		{
			var element = menuList[i];
			if(!element.classList.contains('applGrpHide'))
			{
	    		element.classList.add('applGrpHide');
	    		element.classList.remove('applGrpShow');
			}
			else
			{
				element.classList.add('applGrpShow');
				element.classList.remove('applGrpHide');
			}
		}
	}-*/;
	//Added by Sainath T. on 10-OCT-2019 [To change the properties of application list-collapsible list] -End

}
